/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.TimeUtils;

public class Timer
implements AutoCloseable {
    private final String name;
    private long startedNanos;
    private long stoppedNanos;
    private boolean wasStarted;
    private boolean wasStopped;
    private long totalElapsedNanos;

    public Timer(String name) {
        this.name = name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String name() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Timer start() {
        return this.startAt(System.nanoTime());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Timer startAt(long nanoTime) {
        this.startedNanos = nanoTime;
        this.wasStarted = true;
        this.stoppedNanos = 0L;
        this.wasStopped = false;
        return this;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long startedNanos() {
        if (!this.wasStarted) {
            assert (this.startedNanos == 0L);
            return Isolates.getStartTimeNanos();
        }
        return this.startedNanos;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long stoppedNanos() {
        assert (this.wasStopped) : "Timer not stopped";
        return this.stoppedNanos;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void close() {
        this.stop();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void stop() {
        this.stopAt(System.nanoTime());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void stopAt(long nanoTime) {
        this.stoppedNanos = nanoTime;
        this.wasStopped = true;
        this.totalElapsedNanos += this.stoppedNanos - this.startedNanos();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long lastIntervalNanos() {
        assert (this.wasStopped) : "Timer not stopped";
        return this.stoppedNanos() - this.startedNanos();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long lastIntervalMillis() {
        return TimeUtils.roundNanosToMillis(this.lastIntervalNanos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long totalNanos() {
        return this.totalElapsedNanos;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long totalMillis() {
        return TimeUtils.roundNanosToMillis(this.totalNanos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void reset() {
        this.startedNanos = 0L;
        this.wasStarted = false;
        this.stoppedNanos = 0L;
        this.wasStopped = false;
        this.totalElapsedNanos = 0L;
    }
}

