/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util.coder;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.coder.ByteStream;
import com.oracle.svm.core.util.coder.ByteStreamAccess;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.Pointer;

public class Pack200Coder {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long readUV(Pointer data) {
        ByteStream stream = (ByteStream)StackValue.get(ByteStream.class);
        ByteStreamAccess.initialize(stream, data);
        return Pack200Coder.readUV(stream);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long readUV(ByteStream data) {
        Pointer pos = data.getPosition();
        long result = pos.readByte(0) & 0xFF;
        pos = pos.add(1);
        if (result >= 192L) {
            long shift = 6L;
            int i = 2;
            while (true) {
                long b = pos.readByte(0) & 0xFF;
                pos = pos.add(1);
                result += b << (int)shift;
                if (b < 192L || (long)i == 11L) break;
                shift += 6L;
                ++i;
            }
        }
        data.setPosition(pos);
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readUVAsInt(Pointer data) {
        long result = Pack200Coder.readUV(data);
        assert ((long)((int)result) == result);
        return (int)result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int readUVAsInt(ByteStream data) {
        long result = Pack200Coder.readUV(data);
        assert ((long)((int)result) == result);
        return (int)result;
    }
}

