/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

public class SubstrateInstalledCodeImpl
extends InstalledCode
implements SubstrateInstalledCode {
    public SubstrateInstalledCodeImpl(SharedRuntimeMethod method) {
        super(method.format("%H.%n#(%p)"));
    }

    public SubstrateInstalledCodeImpl(String name, SharedRuntimeMethod method) {
        super(name != null ? name : method.format("%H.%n#(%p)"));
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return null;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getAddress() {
        return this.address;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAlive() {
        return this.address != 0L;
    }

    @Override
    public void setAddress(long address, long entryPoint, ResolvedJavaMethod method) {
        assert (VMOperation.isInProgressAtSafepoint());
        this.address = address;
        this.entryPoint = entryPoint;
    }

    @Override
    public void clearAddress() {
        assert (VMOperation.isInProgressAtSafepoint());
        this.entryPoint = 0L;
        this.address = 0L;
    }

    @Override
    public void invalidate() {
        CodeInfoTable.invalidateInstalledCode(this);
    }

    @Override
    public void makeNonEntrant() {
        assert (VMOperation.isInProgressAtSafepoint());
        throw VMError.unimplemented("cannot make non-entrant");
    }

    @Override
    public SubstrateSpeculationLog getSpeculationLog() {
        return null;
    }

    @Override
    public void setCompilationId(CompilationIdentifier id) {
    }

    public long getStart() {
        return this.getAddress();
    }

    public byte[] getCode() {
        return SubstrateInstalledCodeImpl.getCode((CodePointer)Word.pointer((long)this.entryPoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Accesses code info.")
    public static byte[] getCode(CodePointer entryPointAddress) {
        UntetheredCodeInfo untetheredCodeInfo = CodeInfoTable.lookupCodeInfo(entryPointAddress);
        if (untetheredCodeInfo.isNull()) {
            return null;
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredCodeInfo);
        try {
            CodeInfo codeInfo = CodeInfoAccess.convert(untetheredCodeInfo, tether);
            byte[] byArray = SubstrateInstalledCodeImpl.copyCode0(codeInfo);
            return byArray;
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredCodeInfo, tether);
        }
    }

    @Uninterruptible(reason="Wrap the now safe call to code info.", calleeMustBe=false)
    private static byte[] copyCode0(CodeInfo codeInfo) {
        return SubstrateInstalledCodeImpl.copyCode(CodeInfoAccess.getCodeStart(codeInfo), (int)CodeInfoAccess.getCodeSize(codeInfo).rawValue());
    }

    private static byte[] copyCode(CodePointer codeStart, int codeSize) {
        byte[] code = new byte[codeSize];
        CTypeConversion.asByteBuffer((PointerBase)codeStart, (int)codeSize).get(code);
        return code;
    }

    public Object executeVarargs(Object ... args) {
        throw VMError.shouldNotReachHere("No implementation in Substrate VM");
    }
}

