/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CCallStubMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ClassUtil;
import java.util.Arrays;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CFunction;

public final class CFunctionCallStubMethod
extends CCallStubMethod {
    private final CGlobalDataInfo linkage;

    CFunctionCallStubMethod(ResolvedJavaMethod original, CGlobalDataInfo linkage, int newThreadStatus) {
        super(original, newThreadStatus);
        this.linkage = linkage;
    }

    @Override
    protected String getCorrespondingAnnotationName() {
        return ClassUtil.getUnqualifiedName(this.getAnnotationClass());
    }

    private Class<?> getAnnotationClass() {
        if (this.original.getAnnotation(CFunction.class) != null) {
            return CFunction.class;
        }
        throw VMError.shouldNotReachHere("Method is not annotated with @" + CFunction.class.getSimpleName());
    }

    @Override
    public boolean allowRuntimeCompilation() {
        boolean needsTransition = VMThreads.StatusSupport.isValidStatus(this.newThreadStatus);
        return !needsTransition;
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        VMError.guarantee(purpose != GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION || this.allowRuntimeCompilation(), "Cannot compile cfunction transitions into runtime compiled methods");
        return super.buildGraph(debug, method, providers, purpose);
    }

    @Override
    protected ValueNode createTargetAddressNode(HostedGraphKit kit, List<ValueNode> arguments) {
        return kit.unique(new CGlobalDataLoadAddressNode(this.linkage));
    }

    @Override
    protected ResolvedSignature<AnalysisType> adaptSignatureAndConvertArguments(NativeLibraries nativeLibraries, HostedGraphKit kit, AnalysisMethod method, AnalysisType returnType, AnalysisType[] paramTypes, List<ValueNode> arguments) {
        AnalysisType[] adaptedParamTypes = paramTypes;
        if (method.hasReceiver()) {
            arguments.remove(0);
            adaptedParamTypes = Arrays.copyOfRange(adaptedParamTypes, 1, adaptedParamTypes.length);
        }
        return super.adaptSignatureAndConvertArguments(nativeLibraries, kit, method, returnType, adaptedParamTypes, arguments);
    }
}

