/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jdk.VarHandleInfo;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

final class InstanceVarHandleInfo
extends VarHandleInfo {
    final Function<Object, Class<?>> typeGetter;

    InstanceVarHandleInfo(Function<Object, JavaKind> kindGetter, ToLongFunction<Object> offsetGetter, Function<Object, Class<?>> typeGetter) {
        super(kindGetter, offsetGetter);
        this.typeGetter = typeGetter;
    }

    @Override
    ResolvedJavaField findOriginalField(Object varHandle) {
        JavaKind kind;
        long offset = this.offsetGetter.applyAsLong(varHandle);
        Class<?> clazz = this.typeGetter.apply(varHandle);
        ResolvedJavaType type = GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(clazz);
        ResolvedJavaField result = type.findInstanceFieldWithOffset(offset, kind = (JavaKind)this.kindGetter.apply(varHandle));
        if (result == null) {
            throw VMError.shouldNotReachHere("Could not find instance field referenced in VarHandle: type = " + String.valueOf(type) + ", offset = " + offset + ", kind = " + String.valueOf(kind));
        }
        return result;
    }
}

