/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.util.Arrays;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.hosted.RuntimeSerialization;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticallyRegisteredFeature
public class JmxCommonFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspectionOptions.hasJmxServerSupport() || VMInspectionOptions.hasJmxClientSupport();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtBuildTime("jdk.management.jfr.SettingDescriptorInfo", "JMX support");
        rci.initializeAtBuildTime("sun.rmi.runtime.Log$LogStreamLog", "JMX support");
        rci.initializeAtBuildTime("sun.rmi.runtime.Log", "JMX support");
        rci.initializeAtBuildTime("java.rmi.server.LogStream", "JMX support");
        rci.initializeAtBuildTime("sun.rmi.runtime.Log$LoggerLog", "JMX support");
        rci.initializeAtBuildTime("sun.rmi.server.Util", "JMX support");
        rci.initializeAtBuildTime("jdk.management.jfr.MBeanUtils", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.StandardMBeanIntrospector", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.MXBeanIntrospector", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.MXBeanLookup", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.util.EnvHelp", "JMX support");
        rci.initializeAtBuildTime("java.rmi.server.RemoteObjectInvocationHandler", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.Introspector", "JMX support");
        rci.initializeAtBuildTime("java.beans.Introspector", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.JavaBeansAccessor", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.security.JMXPluggableAuthenticator", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.MBeanInstantiator", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.internal.ArrayNotificationBuffer", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.security.HashedPasswordManager", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.security.JMXSubjectDomainCombiner", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.internal.ServerCommunicatorAdmin", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.defaults.JmxProperties", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.internal.ServerNotifForwarder", "JMX support");
        rci.initializeAtBuildTime("sun.rmi.runtime.Log$LoggerLogFactory", "JMX support");
        rci.initializeAtBuildTime("java.beans.Introspector$1", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.remote.internal.ArrayNotificationBuffer$BroadcasterQuery", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.WeakIdentityHashMap", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.MBeanIntrospector$PerInterfaceMap", "JMX support");
        rci.initializeAtBuildTime("com.sun.jmx.mbeanserver.MBeanIntrospector$MBeanInfoMap", "JMX support");
        rci.initializeAtBuildTime("sun.rmi.runtime.Log$InternalStreamHandler", "JMX support");
        rci.initializeAtBuildTime("java.rmi.server.RemoteObjectInvocationHandler$MethodToHash_Maps", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.ConnectionInputStream", "JMX support");
        rci.initializeAtRunTime("java.rmi.MarshalledObject$MarshalledObjectInputStream", "JMX support");
        rci.initializeAtRunTime("sun.rmi.server.UnicastRef2", "JMX support");
        rci.initializeAtRunTime("sun.rmi.server.UnicastRef", "JMX support");
        rci.initializeAtRunTime("sun.rmi.server.MarshalInputStream", "JMX support");
        rci.initializeAtRunTime("sun.rmi.runtime.NewThreadAction", "JMX support");
        rci.initializeAtRunTime("com.sun.jmx.remote.security.FileLoginModule", "JMX support");
        rci.initializeAtRunTime("com.sun.jmx.remote.security.JMXPluggableAuthenticator$FileLoginConfig", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.DGCImpl", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.DGCAckHandler", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.DGCClient", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.ObjectTable", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.tcp.TCPEndpoint", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.tcp.TCPChannel", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.tcp.TCPTransport", "JMX support");
        rci.initializeAtRunTime("sun.rmi.transport.Transport", "JMX support");
        rci.initializeAtRunTime("java.rmi.server.ObjID", "JMX support");
        rci.initializeAtRunTime("sun.rmi.server.UnicastServerRef", "JMX support");
        rci.initializeAtRunTime("java.rmi.server.UID", "JMX support");
        rci.initializeAtRunTime("sun.rmi.runtime.RuntimeUtil", "JMX support");
        rci.initializeAtRunTime("java.rmi.dgc.VMID", "JMX support");
        rci.initializeAtRunTime("java.rmi.server.RMIClassLoader", "JMX support");
        rci.initializeAtRunTime("sun.rmi.server.LoaderHandler", "JMX support");
        rci.initializeAtRunTime("java.rmi.server.RemoteServer", "JMX support");
        rci.initializeAtRunTime("sun.rmi.registry.RegistryImpl", "JMX support");
        rci.initializeAtRunTime("java.rmi.server.UnicastRemoteObject", "JMX support");
        rci.initializeAtRunTime("sun.rmi.server.UnicastServerRef2", "JMX support");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        JmxCommonFeature.configureJNI();
        JmxCommonFeature.configureSerialization(access);
        JmxCommonFeature.configureReflection(access);
        JmxCommonFeature.configureProxy(access);
    }

    private static void configureProxy(Feature.BeforeAnalysisAccess access) {
        DynamicProxyRegistry dynamicProxySupport = (DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class);
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("com.sun.management.GarbageCollectorMXBean"), access.findClassByName("javax.management.NotificationEmitter")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("com.sun.management.OperatingSystemMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("com.sun.management.ThreadMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("com.sun.management.UnixOperatingSystemMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.BufferPoolMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.ClassLoadingMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.CompilationMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.GarbageCollectorMXBean"), access.findClassByName("javax.management.NotificationEmitter")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.MemoryManagerMXBean"), access.findClassByName("javax.management.NotificationEmitter")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.MemoryManagerMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.MemoryPoolMXBean"), access.findClassByName("javax.management.NotificationEmitter")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.MemoryMXBean"), access.findClassByName("javax.management.NotificationEmitter")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.OperatingSystemMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.RuntimeMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("java.lang.management.ThreadMXBean")});
        dynamicProxySupport.addProxyClass(ConfigurationCondition.alwaysTrue(), new Class[]{access.findClassByName("jdk.management.jfr.FlightRecorderMXBean"), access.findClassByName("javax.management.NotificationEmitter")});
    }

    private static void configureJNI() {
        JNIRuntimeAccess.register(Arrays.class);
        JNIRuntimeAccess.register(ReflectionUtil.lookupMethod(Arrays.class, (String)"asList", (Class[])new Class[]{Object[].class}));
    }

    private static void configureSerialization(Feature.BeforeAnalysisAccess access) {
        String[] classes;
        for (String clazz : classes = new String[]{"[B", "com.oracle.svm.core.jdk.UnsupportedFeatureError", "java.io.IOException", "java.lang.Boolean", "java.lang.ClassCastException", "java.lang.Error", "java.lang.Exception", "java.lang.IllegalArgumentException", "java.lang.IllegalStateException", "java.lang.Double", "java.lang.Integer", "[Ljava.lang.Integer;", "java.lang.Long", "java.lang.NoSuchMethodException", "java.lang.NullPointerException", "java.lang.Number", "[Ljava.lang.Object;", "java.lang.ReflectiveOperationException", "java.lang.RuntimeException", "java.lang.SecurityException", "java.lang.StackTraceElement", "[Ljava.lang.StackTraceElement;", "java.lang.String", "java.lang.Throwable", "java.lang.UnsupportedOperationException", "java.rmi.MarshalledObject", "[Ljava.rmi.MarshalledObject;", "java.rmi.RemoteException", "java.rmi.ServerError", "java.rmi.dgc.Lease", "java.rmi.dgc.VMID", "java.rmi.server.ObjID", "[Ljava.rmi.server.ObjID;", "java.rmi.server.RemoteObject", "java.rmi.server.RemoteStub", "java.rmi.server.UID", "java.security.GeneralSecurityException", "java.util.ArrayList", "java.util.Arrays$ArrayList", "java.util.Collections$EmptyList", "java.util.Collections$UnmodifiableCollection", "java.util.Collections$UnmodifiableList", "java.util.Collections$UnmodifiableRandomAccessList", "java.util.EventObject", "java.util.HashMap", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.MissingResourceException", "java.util.TreeMap", "java.util.Vector", "javax.management.Attribute", "javax.management.AttributeList", "javax.management.AttributeNotFoundException", "javax.management.AttributeChangeNotification", "javax.management.InstanceNotFoundException", "javax.management.JMException", "javax.management.MBeanAttributeInfo", "[Ljavax.management.MBeanAttributeInfo;", "[Ljavax.management.MBeanConstructorInfo;", "javax.management.MBeanFeatureInfo", "javax.management.MBeanInfo", "javax.management.MBeanNotificationInfo", "[Ljavax.management.MBeanNotificationInfo;", "javax.management.MBeanOperationInfo", "[Ljavax.management.MBeanOperationInfo;", "javax.management.MBeanParameterInfo", "[Ljavax.management.MBeanParameterInfo;", "javax.management.Notification", "javax.management.NotificationFilterSupport", "javax.management.ObjectName", "[Ljavax.management.ObjectName;", "javax.management.OperationsException", "javax.management.ReflectionException", "javax.management.openmbean.ArrayType", "javax.management.openmbean.CompositeDataSupport", "[Ljavax.management.openmbean.CompositeData;", "javax.management.openmbean.CompositeType", "javax.management.openmbean.OpenMBeanAttributeInfoSupport", "javax.management.openmbean.OpenMBeanParameterInfoSupport", "javax.management.openmbean.OpenType", "javax.management.openmbean.SimpleType", "javax.management.openmbean.TabularDataSupport", "javax.management.openmbean.TabularType", "javax.management.remote.NotificationResult", "javax.management.remote.TargetedNotification", "[Ljavax.management.remote.TargetedNotification;", "javax.management.remote.rmi.RMIConnectionImpl_Stub", "javax.management.remote.rmi.RMIServerImpl_Stub", "javax.management.RuntimeMBeanException", "javax.rmi.ssl.SslRMIClientSocketFactory", "[Ljavax.security.auth.Subject;", "javax.security.auth.login.FailedLoginException", "javax.security.auth.login.LoginException", "[J", "java.rmi.NoSuchObjectException", "javax.management.JMRuntimeException", "javax.management.RuntimeErrorException"}) {
            RuntimeSerialization.register((Class[])new Class[]{access.findClassByName(clazz)});
        }
    }

    private static void configureReflection(Feature.BeforeAnalysisAccess access) {
        String[] classes = new String[]{"com.sun.management.internal.OperatingSystemImpl", "javax.management.remote.rmi.RMIConnectionImpl_Stub", "javax.management.remote.rmi.RMIServerImpl_Stub", "sun.rmi.registry.RegistryImpl_Stub", "java.rmi.server.RemoteStub", "sun.rmi.registry.RegistryImpl_Skel", "sun.rmi.transport.DGCImpl_Skel", "sun.rmi.server.UnicastRef2", "sun.rmi.transport.DGCImpl", "sun.rmi.transport.DGCImpl_Skel", "sun.rmi.transport.DGCImpl_Stub"};
        String[] methods = new String[]{"com.sun.management.GcInfo", "java.lang.management.LockInfo", "java.lang.management.MemoryUsage", "java.lang.management.MonitorInfo", "java.lang.management.MemoryNotificationInfo", "javax.management.remote.rmi.RMIConnection", "javax.management.remote.rmi.RMIServer", "java.lang.management.ThreadInfo", "jdk.management.jfr.ConfigurationInfo", "jdk.management.jfr.EventTypeInfo", "jdk.management.jfr.RecordingInfo", "jdk.management.jfr.SettingDescriptorInfo"};
        String[] constructors = new String[]{"javax.management.remote.rmi.RMIConnectionImpl_Stub", "javax.management.remote.rmi.RMIServerImpl_Stub", "sun.rmi.transport.DGCImpl_Stub", "sun.rmi.registry.RegistryImpl_Skel", "sun.rmi.registry.RegistryImpl_Stub", "sun.rmi.transport.DGCImpl_Skel"};
        for (String clazz : classes) {
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName(clazz)});
        }
        for (String clazz : methods) {
            RuntimeReflection.register((Executable[])access.findClassByName(clazz).getMethods());
        }
        for (String clazz : constructors) {
            RuntimeReflection.register((Executable[])access.findClassByName(clazz).getConstructors());
        }
    }
}

