/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.svm.hosted.lambda.LambdaSubstitutionType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.vm.ci.meta.ResolvedJavaType;

public class LambdaProxyRenamingSubstitutionProcessor
extends SubstitutionProcessor {
    private final ConcurrentHashMap<ResolvedJavaType, LambdaSubstitutionType> typeSubstitutions = new ConcurrentHashMap();
    private final Set<String> uniqueLambdaProxyNames = new HashSet<String>();

    LambdaProxyRenamingSubstitutionProcessor() {
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        if (LambdaUtils.isLambdaType((ResolvedJavaType)type) && !type.getClass().equals(LambdaSubstitutionType.class) && !type.getClass().equals(BaseLayerType.class)) {
            return this.getSubstitution(type);
        }
        return type;
    }

    private LambdaSubstitutionType getSubstitution(ResolvedJavaType original) {
        return this.typeSubstitutions.computeIfAbsent(original, key -> {
            String lambdaTargetName = LambdaUtils.findStableLambdaName((ResolvedJavaType)key);
            return new LambdaSubstitutionType((ResolvedJavaType)key, this.findUniqueLambdaProxyName(lambdaTargetName));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findUniqueLambdaProxyName(String lambdaTargetName) {
        Set<String> set = this.uniqueLambdaProxyNames;
        synchronized (set) {
            String stableNameBase = lambdaTargetName.substring(0, lambdaTargetName.length() - 1);
            String newStableName = stableNameBase + "0;";
            int i = 1;
            while (this.uniqueLambdaProxyNames.contains(newStableName)) {
                newStableName = stableNameBase + i + ";";
                ++i;
            }
            this.uniqueLambdaProxyNames.add(newStableName);
            return newStableName;
        }
    }

    private static String getBaseName(String lambdaTargetName) {
        int startIndexOfHash = lambdaTargetName.indexOf(".0x") + ".0x".length();
        return lambdaTargetName.substring(0, startIndexOfHash + 32);
    }

    public boolean isNameAlwaysStable(String lambdaTargetName) {
        String baseName = LambdaProxyRenamingSubstitutionProcessor.getBaseName(lambdaTargetName);
        return !this.uniqueLambdaProxyNames.contains(baseName + "1;");
    }
}

