/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.option;

import com.oracle.svm.common.option.CommonOptionParser;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsContainer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.Platforms;

public class HostedOptionParser
implements HostedOptionProvider {
    private final List<String> arguments;
    private final EconomicMap<OptionKey<?>, Object> hostedValues = OptionValues.newOptionMap();
    private final EconomicMap<OptionKey<?>, Object> runtimeValues = OptionValues.newOptionMap();
    private final EconomicMap<String, OptionDescriptor> allHostedOptions = EconomicMap.create();
    private final EconomicMap<String, OptionDescriptor> allRuntimeOptions = EconomicMap.create();

    public HostedOptionParser(ClassLoader imageClassLoader, List<String> arguments) {
        this.arguments = Collections.unmodifiableList(arguments);
        HostedOptionParser.collectOptions(OptionsContainer.getDiscoverableOptions((ClassLoader)imageClassLoader), this.allHostedOptions, this.allRuntimeOptions);
    }

    public static void collectOptions(Iterable<OptionDescriptors> optionDescriptors, EconomicMap<String, OptionDescriptor> allHostedOptions, EconomicMap<String, OptionDescriptor> allRuntimeOptions) {
        SubstrateOptionsParser.collectOptions(optionDescriptors, descriptor -> {
            OptionDescriptor existing;
            String name = descriptor.getName();
            if (descriptor.getDeclaringClass().getAnnotation(Platforms.class) != null) {
                throw UserError.abort("Options must not be declared in a class that has a @%s annotation: option %s declared in %s", Platforms.class.getSimpleName(), name, descriptor.getDeclaringClass().getTypeName());
            }
            if (!(descriptor.getOptionKey() instanceof RuntimeOptionKey) && (existing = (OptionDescriptor)allHostedOptions.put((Object)name, descriptor)) != null) {
                throw VMError.shouldNotReachHere("Option name \"" + name + "\" has multiple definitions: " + existing.getLocation() + " and " + descriptor.getLocation());
            }
            if (!(descriptor.getOptionKey() instanceof HostedOptionKey) && (existing = (OptionDescriptor)allRuntimeOptions.put((Object)name, descriptor)) != null) {
                throw VMError.shouldNotReachHere("Option name \"" + name + "\" has multiple definitions: " + existing.getLocation() + " and " + descriptor.getLocation());
            }
        });
    }

    public List<String> parse() {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        HashSet<String> errors = new HashSet<String>();
        InterruptImageBuilding interrupt = null;
        for (String arg : this.arguments) {
            boolean isImageBuildOption = false;
            try {
                isImageBuildOption |= SubstrateOptionsParser.parseHostedOption("-H:", this.allHostedOptions, this.hostedValues, CommonOptionParser.BooleanOptionFormat.PLUS_MINUS, errors, arg, System.out);
            }
            catch (InterruptImageBuilding e) {
                interrupt = e;
            }
            try {
                isImageBuildOption |= SubstrateOptionsParser.parseHostedOption("-R:", this.allRuntimeOptions, this.runtimeValues, CommonOptionParser.BooleanOptionFormat.PLUS_MINUS, errors, arg, System.out);
            }
            catch (InterruptImageBuilding e) {
                interrupt = e;
            }
            if (isImageBuildOption) continue;
            remainingArgs.add(arg);
        }
        if (interrupt != null) {
            throw interrupt;
        }
        if (!errors.isEmpty()) {
            throw UserError.abort(errors);
        }
        for (OptionDescriptor descriptor : this.allRuntimeOptions.getValues()) {
            if (this.allHostedOptions.containsKey((Object)descriptor.getName())) continue;
            this.hostedValues.put((Object)descriptor.getOptionKey(), null);
        }
        return remainingArgs;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public EconomicMap<String, OptionDescriptor> getAllHostedOptions() {
        return this.allHostedOptions;
    }

    public EconomicMap<String, OptionDescriptor> getAllRuntimeOptions() {
        return this.allRuntimeOptions;
    }

    @Override
    public EconomicMap<OptionKey<?>, Object> getHostedValues() {
        return this.hostedValues;
    }

    @Override
    public EconomicMap<OptionKey<?>, Object> getRuntimeValues() {
        return this.runtimeValues;
    }

    public EconomicSet<String> getRuntimeOptionNames() {
        EconomicSet res = EconomicSet.create((int)this.allRuntimeOptions.size());
        this.allRuntimeOptions.getKeys().forEach(arg_0 -> ((EconomicSet)res).add(arg_0));
        return res;
    }
}

