/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.snippets.OpenTypeWorldDispatchTableSnippets;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.monitor.MonitorInflationCause;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.Interpreter;
import com.oracle.svm.interpreter.InterpreterFrame;
import com.oracle.svm.interpreter.InterpreterMethodPointerHolder;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.SemanticJavaException;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.MissingReflectionRegistrationError;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@InternalVMMethod
public final class InterpreterToVM {
    private static final JavaKind WORD_KIND = ConfigurationValues.getTarget().wordJavaKind;
    private static final Unsafe U;

    public static JavaKind wordJavaKind() {
        return WORD_KIND;
    }

    private InterpreterToVM() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public static int getArrayInt(int index, int[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static Object getArrayObject(int index, Object[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static long getArrayLong(int index, long[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static WordBase getArrayWord(int index, WordBase[] wordArray) throws SemanticJavaException {
        assert (wordArray != null);
        try {
            return wordArray[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static float getArrayFloat(int index, float[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static double getArrayDouble(int index, double[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static byte getArrayByte(int index, Object array) throws SemanticJavaException {
        assert (array != null);
        try {
            if (array instanceof byte[]) {
                return ((byte[])array)[index];
            }
            return ((boolean[])array)[index] ? (byte)1 : 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static char getArrayChar(int index, char[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static short getArrayShort(int index, short[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayInt(int value, int index, int[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayLong(long value, int index, long[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayWord(WordBase value, int index, WordBase[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayFloat(float value, int index, float[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayDouble(double value, int index, double[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayByte(byte value, int index, Object array) throws SemanticJavaException {
        assert (array != null);
        try {
            if (array instanceof byte[]) {
                ((byte[])array)[index] = value;
            } else {
                ((boolean[])array)[index] = (value & 1) != 0;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayChar(char value, int index, char[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayShort(short value, int index, short[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void setArrayObject(Object value, int index, Object[] array) throws SemanticJavaException {
        assert (array != null);
        try {
            array[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException | ArrayStoreException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static void monitorEnter(InterpreterFrame frame, Object obj) throws SemanticJavaException {
        assert (obj != null);
        MonitorSupport.singleton().monitorEnter(obj, MonitorInflationCause.MONITOR_ENTER);
        frame.addLock(obj);
    }

    @SuppressFBWarnings(value={"IMSE_DONT_CATCH_IMSE"}, justification="Intentional.")
    public static void monitorExit(InterpreterFrame frame, Object obj) throws SemanticJavaException {
        assert (obj != null);
        try {
            MonitorSupport.singleton().monitorExit(obj, MonitorInflationCause.VM_INTERNAL);
            frame.removeLock(obj);
        }
        catch (IllegalMonitorStateException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    @SuppressFBWarnings(value={"IMSE_DONT_CATCH_IMSE"}, justification="Intentional.")
    public static void releaseInterpreterFrameLocks(InterpreterFrame frame) throws SemanticJavaException {
        Object[] locks = frame.getLocks();
        for (int i = 0; i < locks.length; ++i) {
            Object ref = locks[i];
            if (ref == null) continue;
            try {
                MonitorSupport.singleton().monitorExit(ref, MonitorInflationCause.VM_INTERNAL);
                locks[i] = null;
                continue;
            }
            catch (IllegalMonitorStateException e) {
                throw SemanticJavaException.raise(e);
            }
        }
    }

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while trying to get Unsafe", e);
            }
        }
    }

    public static WordBase getFieldWord(Object obj, InterpreterResolvedJavaField wordField) throws SemanticJavaException {
        assert (obj != null);
        assert (wordField.getType().isWordType());
        return switch (InterpreterToVM.wordJavaKind()) {
            case JavaKind.Long -> Word.signed((long)InterpreterToVM.getFieldLong(obj, wordField));
            case JavaKind.Int -> Word.signed((int)InterpreterToVM.getFieldInt(obj, wordField));
            default -> throw VMError.shouldNotReachHere("Unexpected word kind " + String.valueOf(InterpreterToVM.wordJavaKind()));
        };
    }

    public static boolean getFieldBoolean(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return field.getUnmaterializedConstant().asBoolean();
        }
        if (field.isVolatile()) {
            return U.getBooleanVolatile(obj, field.getOffset());
        }
        return U.getBoolean(obj, field.getOffset());
    }

    public static int getFieldInt(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return field.getUnmaterializedConstant().asInt();
        }
        if (field.isVolatile()) {
            return U.getIntVolatile(obj, field.getOffset());
        }
        return U.getInt(obj, field.getOffset());
    }

    public static long getFieldLong(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return field.getUnmaterializedConstant().asLong();
        }
        if (field.isVolatile()) {
            return U.getLongVolatile(obj, field.getOffset());
        }
        return U.getLong(obj, field.getOffset());
    }

    public static byte getFieldByte(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return (byte)field.getUnmaterializedConstant().asInt();
        }
        if (field.isVolatile()) {
            return U.getByteVolatile(obj, field.getOffset());
        }
        return U.getByte(obj, field.getOffset());
    }

    public static short getFieldShort(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return (short)field.getUnmaterializedConstant().asInt();
        }
        if (field.isVolatile()) {
            return U.getShortVolatile(obj, field.getOffset());
        }
        return U.getShort(obj, field.getOffset());
    }

    public static float getFieldFloat(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return field.getUnmaterializedConstant().asFloat();
        }
        if (field.isVolatile()) {
            return U.getFloatVolatile(obj, field.getOffset());
        }
        return U.getFloat(obj, field.getOffset());
    }

    public static double getFieldDouble(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return field.getUnmaterializedConstant().asDouble();
        }
        if (field.isVolatile()) {
            return U.getDoubleVolatile(obj, field.getOffset());
        }
        return U.getDouble(obj, field.getOffset());
    }

    public static Object getFieldObject(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            JavaConstant constant = field.getUnmaterializedConstant();
            if (JavaConstant.NULL_POINTER.equals((Object)constant)) {
                return null;
            }
            VMError.guarantee(!constant.equals((Object)PrimitiveConstant.ILLEGAL), "Trying to load constant that is not part of the Native Image heap");
            VMError.guarantee(constant.isNonNull(), "Trying to load constant that is not part of the Native Image heap");
            return ((ReferenceConstant)constant).getReferent();
        }
        if (field.isVolatile()) {
            return U.getReferenceVolatile(obj, field.getOffset());
        }
        return U.getReference(obj, field.getOffset());
    }

    public static char getFieldChar(Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isUnmaterializedConstant()) {
            return (char)field.getUnmaterializedConstant().asInt();
        }
        if (field.isVolatile()) {
            return U.getCharVolatile(obj, field.getOffset());
        }
        return U.getChar(obj, field.getOffset());
    }

    public static void setFieldBoolean(boolean value, Object obj, InterpreterResolvedJavaField field) {
        if (field.isVolatile()) {
            U.putBooleanVolatile(obj, field.getOffset(), value);
        } else {
            U.putBoolean(obj, field.getOffset(), value);
        }
    }

    public static void setFieldByte(byte value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isVolatile()) {
            U.putByteVolatile(obj, field.getOffset(), value);
        } else {
            U.putByte(obj, field.getOffset(), value);
        }
    }

    public static void setFieldChar(char value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isVolatile()) {
            U.putCharVolatile(obj, field.getOffset(), value);
        } else {
            U.putChar(obj, field.getOffset(), value);
        }
    }

    public static void setFieldShort(short value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isVolatile()) {
            U.putShortVolatile(obj, field.getOffset(), value);
        } else {
            U.putShort(obj, field.getOffset(), value);
        }
    }

    public static void setFieldInt(int value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        assert (field.getJavaKind() == JavaKind.Int || field.getType().isWordType());
        if (field.isVolatile()) {
            U.putIntVolatile(obj, field.getOffset(), value);
        } else {
            U.putInt(obj, field.getOffset(), value);
        }
    }

    public static void setFieldLong(long value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        assert (field.getJavaKind() == JavaKind.Long || field.getType().isWordType());
        if (field.isVolatile()) {
            U.putLongVolatile(obj, field.getOffset(), value);
        } else {
            U.putLong(obj, field.getOffset(), value);
        }
    }

    public static void setFieldWord(WordBase value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        switch (InterpreterToVM.wordJavaKind()) {
            case Int: {
                InterpreterToVM.setFieldInt((int)value.rawValue(), obj, field);
                break;
            }
            case Long: {
                InterpreterToVM.setFieldLong(value.rawValue(), obj, field);
                break;
            }
            default: {
                throw VMError.shouldNotReachHere("Unexpected word kind " + String.valueOf(InterpreterToVM.wordJavaKind()));
            }
        }
    }

    public static void setFieldFloat(float value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isVolatile()) {
            U.putFloatVolatile(obj, field.getOffset(), value);
        } else {
            U.putFloat(obj, field.getOffset(), value);
        }
    }

    public static void setFieldDouble(double value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isVolatile()) {
            U.putDoubleVolatile(obj, field.getOffset(), value);
        } else {
            U.putDouble(obj, field.getOffset(), value);
        }
    }

    public static void setFieldObject(Object value, Object obj, InterpreterResolvedJavaField field) {
        assert (obj != null);
        if (field.isVolatile()) {
            U.putReferenceVolatile(obj, field.getOffset(), value);
        } else {
            U.putReference(obj, field.getOffset(), value);
        }
    }

    public static boolean instanceOf(Object instance, InterpreterResolvedJavaType typeToCheck) {
        return InterpreterToVM.instanceOf(instance, typeToCheck.getJavaClass());
    }

    public static boolean instanceOf(Object instance, Class<?> classToCheck) {
        if (instance == null) {
            return false;
        }
        return classToCheck.isAssignableFrom(instance.getClass());
    }

    private static String cannotCastMsg(Object instance, Class<?> clazz) {
        return "Cannot cast " + instance.getClass().getName() + " to " + clazz.getName();
    }

    public static Object checkCast(Object instance, Class<?> classToCheck) throws SemanticJavaException {
        assert (classToCheck != null);
        if (GraalDirectives.injectBranchProbability((double)1.0E-4, (instance != null && !InterpreterToVM.instanceOf(instance, classToCheck) ? 1 : 0) != 0)) {
            throw SemanticJavaException.raise(new ClassCastException(InterpreterToVM.cannotCastMsg(instance, classToCheck)));
        }
        return instance;
    }

    public static Object checkCast(Object instance, InterpreterResolvedJavaType typeToCheck) throws SemanticJavaException {
        return InterpreterToVM.checkCast(instance, typeToCheck.getJavaClass());
    }

    public static int arrayLength(Object array) {
        assert (array != null && array.getClass().isArray());
        return ArrayLengthNode.arrayLength((Object)array);
    }

    public static Object createNewReference(InterpreterResolvedJavaType klass) throws SemanticJavaException {
        assert (!klass.isPrimitive());
        Class<?> clazz = klass.getJavaClass();
        InterpreterToVM.ensureClassInitialized(clazz);
        try {
            return U.allocateInstance(clazz);
        }
        catch (IllegalArgumentException | InstantiationException | MissingReflectionRegistrationError e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static Object createNewPrimitiveArray(byte jvmPrimitiveType, int length) throws SemanticJavaException {
        try {
            return switch (jvmPrimitiveType) {
                case 4 -> new boolean[length];
                case 5 -> (Object[])new char[length];
                case 6 -> (Object[])new float[length];
                case 7 -> (Object[])new double[length];
                case 8 -> (Object[])new byte[length];
                case 9 -> (Object[])new short[length];
                case 10 -> (Object[])new int[length];
                case 11 -> (Object[])new long[length];
                default -> throw VMError.shouldNotReachHereAtRuntime();
            };
        }
        catch (NegativeArraySizeException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    public static Object createNewReferenceArray(InterpreterResolvedJavaType componentType, int length) throws SemanticJavaException {
        assert (componentType.getJavaKind() != JavaKind.Void);
        assert (!componentType.getJavaKind().isPrimitive());
        assert (InterpreterToVM.getDimensions(componentType) + 1 <= 255);
        if (length < 0) {
            throw SemanticJavaException.raise(new NegativeArraySizeException(String.valueOf(length)));
        }
        return Array.newInstance(componentType.getJavaClass(), length);
    }

    private static int getDimensions(ResolvedJavaType object) {
        int dimensions = 0;
        ResolvedJavaType elem = object;
        while (elem.isArray()) {
            ++dimensions;
            elem = elem.getComponentType();
        }
        return dimensions;
    }

    public static Object createMultiArray(InterpreterResolvedJavaType multiArrayType, int[] dimensions) throws SemanticJavaException {
        assert (dimensions.length > 0);
        assert (InterpreterToVM.getDimensions(multiArrayType) >= dimensions.length);
        assert (InterpreterToVM.getDimensions(multiArrayType) <= 255);
        InterpreterResolvedJavaType component = multiArrayType;
        for (int d : dimensions) {
            if (d < 0) {
                throw SemanticJavaException.raise(new NegativeArraySizeException(String.valueOf(d)));
            }
            component = (InterpreterResolvedJavaType)component.getComponentType();
        }
        return Array.newInstance(component.getJavaClass(), dimensions);
    }

    public static void ensureClassInitialized(InterpreterResolvedObjectType type) {
        InterpreterToVM.ensureClassInitialized(type.getJavaClass());
    }

    public static void ensureClassInitialized(Class<?> clazz) throws SemanticJavaException {
        assert (clazz != null);
        try {
            EnsureClassInitializedNode.ensureClassInitialized(clazz);
        }
        catch (Error e) {
            throw SemanticJavaException.raise(e);
        }
    }

    static CFunctionPointer peekAtSVMVTable(Class<?> seedClass, Class<?> thisClass, int vTableIndex, boolean isInvokeInterface) {
        DynamicHub seedHub = DynamicHub.fromClass(seedClass);
        DynamicHub thisHub = DynamicHub.fromClass(thisClass);
        int vtableOffset = KnownOffsets.singleton().getVTableOffset(vTableIndex, false);
        if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
            vtableOffset += KnownOffsets.singleton().getVTableBaseOffset();
        } else {
            VMError.guarantee(seedHub.isInterface() == isInvokeInterface);
            vtableOffset = !seedHub.isInterface() ? (vtableOffset += KnownOffsets.singleton().getVTableBaseOffset()) : (vtableOffset += (int)OpenTypeWorldDispatchTableSnippets.determineITableStartingOffset(thisHub, seedHub.getTypeID()));
        }
        WordBase vtableEntry = Word.objectToTrackedPointer((Object)thisHub).readWord(vtableOffset);
        return InterpreterToVM.getSVMVTableCodePointer(vtableEntry);
    }

    private static CFunctionPointer getSVMVTableCodePointer(WordBase vtableEntry) {
        WordBase codePointer = vtableEntry;
        if (SubstrateOptions.useRelativeCodePointers()) {
            codePointer = KnownIntrinsics.codeBase().add((UnsignedWord)codePointer);
        }
        return (CFunctionPointer)codePointer;
    }

    private static InterpreterResolvedJavaMethod peekAtInterpreterVTable(Class<?> seedClass, Class<?> thisClass, int vTableIndex, boolean isInvokeInterface) {
        if (!InterpreterOptions.DebuggerWithInterpreter.getValue().booleanValue()) {
            assert (RuntimeClassLoading.isSupported());
            throw VMError.unimplemented("obtain java type with vtable mirror");
        }
        DebuggerSupport interpreterSupport = (DebuggerSupport)ImageSingletons.lookup(DebuggerSupport.class);
        ResolvedJavaType thisType = interpreterSupport.getUniverse().lookupType(thisClass);
        VMError.guarantee(thisType != null);
        VMError.guarantee(thisType instanceof InterpreterResolvedObjectType);
        InterpreterResolvedJavaMethod[] vTable = ((InterpreterResolvedObjectType)thisType).getVtable();
        VMError.guarantee(vTable != null);
        DynamicHub seedHub = DynamicHub.fromClass(seedClass);
        if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
            VMError.guarantee(vTableIndex > 0 && vTableIndex < vTable.length);
            return vTable[vTableIndex];
        }
        VMError.guarantee(seedHub.isInterface() == isInvokeInterface);
        if (!seedHub.isInterface()) {
            return vTable[vTableIndex];
        }
        int iTableStartingIndex = InterpreterToVM.determineITableStartingIndex(DynamicHub.fromClass(thisClass), seedHub.getTypeID());
        return vTable[iTableStartingIndex + vTableIndex];
    }

    private static int determineITableStartingIndex(DynamicHub thisHub, int interfaceID) {
        long iTableStartingOffset = OpenTypeWorldDispatchTableSnippets.determineITableStartingOffset(thisHub, interfaceID);
        int vtableBaseOffset = KnownOffsets.singleton().getVTableBaseOffset();
        int vtableEntrySize = KnownOffsets.singleton().getVTableEntrySize();
        return (int)(iTableStartingOffset - (long)vtableBaseOffset) / vtableEntrySize;
    }

    public static Object dispatchInvocation(InterpreterResolvedJavaMethod seedMethod, Object[] calleeArgs, boolean isVirtual0, boolean forceStayInInterpreter, boolean preferStayInInterpreter, boolean isInvokeInterface) throws SemanticJavaException {
        boolean isVirtual = isVirtual0;
        boolean goThroughPLT = forceStayInInterpreter ? false : !preferStayInInterpreter;
        InterpreterResolvedObjectType seedDeclaringClass = seedMethod.getDeclaringClass();
        if (seedMethod.isStatic()) {
            InterpreterUtil.guarantee(!isVirtual, "no virtual calls for static method %s", seedMethod);
            InterpreterToVM.ensureClassInitialized(seedDeclaringClass);
        }
        CFunctionPointer calleeFtnPtr = (CFunctionPointer)Word.nullPointer();
        if (goThroughPLT) {
            if (seedMethod.hasNativeEntryPoint()) {
                calleeFtnPtr = seedMethod.getNativeEntryPoint();
                InterpreterUtil.traceInterpreter("got native entry point: ").hex((WordBase)calleeFtnPtr).newline();
            } else if (seedMethod.getVTableIndex() == -1) {
                goThroughPLT = false;
                if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
                    InterpreterUtil.traceInterpreter("fall back to interp for compile entry ").string(seedMethod.toString()).string(" because it has not been compiled.").newline();
                }
            } else if (seedMethod.getVTableIndex() == -2) {
                goThroughPLT = seedMethod.getOneImplementation().hasNativeEntryPoint();
            } else if (!isVirtual && seedMethod.hasVTableIndex()) {
                goThroughPLT = false;
                if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
                    InterpreterUtil.traceInterpreter("invokespecial: ").string(seedMethod.toString()).newline();
                }
            } else if (isVirtual && !seedMethod.hasVTableIndex()) {
                VMError.shouldNotReachHere("cannot do virtual dispatch without vtable index");
            }
        }
        if (isVirtual && (seedMethod.isFinalFlagSet() || calleeArgs[0].getClass().isArray() || seedDeclaringClass.isLeaf() || seedMethod.isPrivate())) {
            isVirtual = false;
            if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
                InterpreterUtil.traceInterpreter("reverting virtual call to invokespecial: ").string(seedMethod.toString()).newline();
            }
        }
        InterpreterResolvedJavaMethod targetMethod = seedMethod;
        if (isVirtual && seedMethod.hasVTableIndex()) {
            VMError.guarantee(seedMethod.hasReceiver());
            Class<?> thisClazz = calleeArgs[0].getClass();
            Class<?> seedClazz = seedDeclaringClass.getJavaClass();
            int vtableIndex = seedMethod.getVTableIndex();
            if (goThroughPLT && (calleeFtnPtr = InterpreterToVM.peekAtSVMVTable(seedClazz, thisClazz, vtableIndex, isInvokeInterface)).equal((ComparableWord)InterpreterMethodPointerHolder.getMethodNotCompiledHandler())) {
                goThroughPLT = false;
                if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
                    InterpreterUtil.traceInterpreter("fall back to interp (vtable entry) for compile entry ").string(seedMethod.toString()).string(" because it has not been compiled.").newline();
                }
            }
            targetMethod = InterpreterToVM.peekAtInterpreterVTable(seedClazz, thisClazz, vtableIndex, isInvokeInterface);
        } else if (seedMethod.getVTableIndex() == -2) {
            targetMethod = seedMethod.getOneImplementation();
            if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
                InterpreterUtil.traceInterpreter("found oneImpl: ").string(targetMethod.toString());
                if (goThroughPLT) {
                    calleeFtnPtr = targetMethod.getNativeEntryPoint();
                    InterpreterUtil.traceInterpreter(" ... with compiled entry=").hex((WordBase)calleeFtnPtr);
                }
                InterpreterUtil.traceInterpreter("").newline();
            }
            VMError.guarantee(targetMethod != null, "VTBL_ONE_IMPL implies that oneImplementation is available in seedMethod");
        }
        if (!targetMethod.hasBytecodes() && !goThroughPLT && calleeFtnPtr.isNonNull()) {
            goThroughPLT = true;
            if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
                InterpreterUtil.traceInterpreter("cannot interpret ").string(targetMethod.toString()).string(" falling back to compiled version ").hex((WordBase)calleeFtnPtr).newline();
            }
        }
        if (!goThroughPLT && targetMethod.isNative()) {
            VMError.guarantee(targetMethod.hasNativeEntryPoint());
            calleeFtnPtr = targetMethod.getNativeEntryPoint();
            VMError.guarantee(calleeFtnPtr.isNonNull());
            goThroughPLT = true;
        }
        if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            InterpreterUtil.traceInterpreter(" ".repeat(Interpreter.logIndent.get())).string(" -> calling (").string(goThroughPLT ? "plt" : "interp").string(") ").string(targetMethod.hasNativeEntryPoint() ? "(compiled entry available) " : "");
            if (targetMethod.hasNativeEntryPoint()) {
                InterpreterUtil.traceInterpreter("(addr: ").hex((WordBase)calleeFtnPtr).string(" ) ");
            }
            InterpreterUtil.traceInterpreter(targetMethod.getDeclaringClass().getName()).string("::").string(targetMethod.getName()).string(targetMethod.getSignature().toMethodDescriptor()).newline();
        }
        Object retObj = null;
        if (goThroughPLT) {
            VMError.guarantee(!forceStayInInterpreter);
            VMError.guarantee(calleeFtnPtr.isNonNull());
            retObj = InterpreterStubSection.leaveInterpreter(calleeFtnPtr, targetMethod, targetMethod.getDeclaringClass(), calleeArgs);
        } else {
            try {
                retObj = Interpreter.execute(targetMethod, calleeArgs, forceStayInInterpreter);
            }
            catch (Throwable e) {
                throw SemanticJavaException.raise(e);
            }
        }
        return retObj;
    }

    public static Object nullCheck(Object value) throws SemanticJavaException {
        if (GraalDirectives.injectBranchProbability((double)0.9999, (value != null ? 1 : 0) != 0)) {
            return value;
        }
        throw SemanticJavaException.raise(new NullPointerException());
    }

    static {
        VMError.guarantee(WORD_KIND == JavaKind.Int || WORD_KIND == JavaKind.Long);
        U = InterpreterToVM.initUnsafe();
    }
}

