/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class InterpreterResolvedPrimitiveType
extends InterpreterResolvedJavaType {
    private final JavaKind kind;
    static final InterpreterResolvedPrimitiveType BOOLEAN = new InterpreterResolvedPrimitiveType(JavaKind.Boolean);
    static final InterpreterResolvedPrimitiveType BYTE = new InterpreterResolvedPrimitiveType(JavaKind.Byte);
    static final InterpreterResolvedPrimitiveType SHORT = new InterpreterResolvedPrimitiveType(JavaKind.Short);
    static final InterpreterResolvedPrimitiveType CHAR = new InterpreterResolvedPrimitiveType(JavaKind.Char);
    static final InterpreterResolvedPrimitiveType INT = new InterpreterResolvedPrimitiveType(JavaKind.Int);
    static final InterpreterResolvedPrimitiveType FLOAT = new InterpreterResolvedPrimitiveType(JavaKind.Float);
    static final InterpreterResolvedPrimitiveType LONG = new InterpreterResolvedPrimitiveType(JavaKind.Long);
    static final InterpreterResolvedPrimitiveType DOUBLE = new InterpreterResolvedPrimitiveType(JavaKind.Double);
    static final InterpreterResolvedPrimitiveType VOID = new InterpreterResolvedPrimitiveType(JavaKind.Void);

    private InterpreterResolvedPrimitiveType(JavaKind kind) {
        super(String.valueOf(kind.getTypeChar()), kind.toJavaClass());
        assert (kind.isPrimitive());
        this.kind = kind;
    }

    public static InterpreterResolvedPrimitiveType fromKind(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return BOOLEAN;
            }
            case Byte: {
                return BYTE;
            }
            case Short: {
                return SHORT;
            }
            case Char: {
                return CHAR;
            }
            case Int: {
                return INT;
            }
            case Float: {
                return FLOAT;
            }
            case Long: {
                return LONG;
            }
            case Double: {
                return DOUBLE;
            }
            case Void: {
                return VOID;
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    public int getModifiers() {
        return 1041;
    }

    public ResolvedJavaType getComponentType() {
        return null;
    }

    public JavaKind getJavaKind() {
        return this.kind;
    }

    public String getSourceFileName() {
        return null;
    }

    public ResolvedJavaType getSuperclass() {
        return null;
    }

    public ResolvedJavaType[] getInterfaces() {
        return new ResolvedJavaType[0];
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return this.equals(other);
    }
}

