/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class LEB128 {
    public static int readUnsignedInt(DataInput in) throws IOException {
        int result = 0;
        int i = 0;
        while (true) {
            byte b = in.readByte();
            result |= (b & 0x7F) << i * 7;
            if (i == 4 && (b & 0xF0) != 0) {
                throw new ArithmeticException("Value is larger than 32-bits");
            }
            if ((b & 0x80) == 0) {
                return result;
            }
            ++i;
        }
    }

    public static void writeUnsignedInt(DataOutput out, int value) throws IOException {
        int tmp = value;
        do {
            int b = tmp & 0x7F;
            if ((tmp >>>= 7) != 0) {
                b |= 0x80;
            }
            out.writeByte(b);
        } while (tmp != 0);
    }

    private static int zigZagEncodeSign(int value) {
        return value << 1 ^ value >> 31;
    }

    private static int zigZagDecodeSign(int value) {
        return value >>> 1 ^ -(value & 1);
    }

    public static int readSignedInt(DataInput in) throws IOException {
        return LEB128.zigZagDecodeSign(LEB128.readUnsignedInt(in));
    }

    public static void writeSignedInt(DataOutput out, int value) throws IOException {
        LEB128.writeUnsignedInt(out, LEB128.zigZagEncodeSign(value));
    }
}

