/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.StackFrame;

public interface JDWPBridge {
    public static final int UNKNOWN_BCI = -1;
    public static final int UNINITIALIZED_LINE_NUMBER = -2;
    public static final long GLOBAL = 0L;

    public void setEventEnabled(long var1, int var3, boolean var4);

    public boolean isEventEnabled(long var1, int var3);

    public void toggleBreakpoint(long var1, int var3, boolean var4);

    public void toggleMethodEnterEvent(long var1, boolean var3);

    public void toggleMethodExitEvent(long var1, boolean var3);

    public void setSteppingFromLocation(long var1, int var3, int var4, long var5, int var7, int var8);

    default public void setStepping(long threadId, int depth, int size) {
        this.setSteppingFromLocation(threadId, depth, size, 0L, -1, -2);
    }

    public void clearStepping(long var1);

    public Packet dispatch(Packet var1) throws JDWPException;

    public int getThreadStatus(long var1) throws JDWPException;

    public long threadSuspend(long var1);

    public long threadResume(long var1);

    public long[] vmSuspend(long[] var1);

    public void vmResume(long[] var1);

    public void setThreadRequest(boolean var1, boolean var2);

    public String getSystemProperty(String var1);

    public long typeRefIndexToId(int var1);

    public long fieldRefIndexToId(int var1);

    public long methodRefIndexToId(int var1);

    public int typeRefIdToIndex(long var1);

    public int fieldRefIdToIndex(long var1);

    public int methodRefIdToIndex(long var1);

    public String currentWorkingDirectory();

    public int[] typeStatus(long ... var1);

    public StackFrame[] getThreadFrames(long var1);

    public boolean isCurrentThreadVirtual();

    public long getCurrentThis();
}

