/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.ForeignSupport;
import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.StubPointer;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_NativeEntryPoint;
import com.oracle.svm.core.foreign.TrampolineSet;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.headers.WindowsAPIs;
import com.oracle.svm.core.image.DisallowedImageHeapObjects;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.word.Word;
import jdk.internal.foreign.CABI;
import jdk.internal.foreign.MemorySessionImpl;
import jdk.internal.foreign.abi.CapturableState;
import jdk.internal.foreign.abi.LinkerOptions;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.MissingForeignRegistrationError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

public class ForeignFunctionsRuntime
implements ForeignSupport {
    private final AbiUtils.TrampolineTemplate trampolineTemplate;
    private final EconomicMap<NativeEntryPointInfo, FunctionPointerHolder> downcallStubs = EconomicMap.create();
    private final EconomicMap<Pair<DirectMethodHandleDesc, JavaEntryPointInfo>, FunctionPointerHolder> directUpcallStubs = EconomicMap.create();
    private final EconomicMap<JavaEntryPointInfo, FunctionPointerHolder> upcallStubs = EconomicMap.create();
    private final Map<Long, TrampolineSet> trampolines = new HashMap<Long, TrampolineSet>();
    private TrampolineSet currentTrampolineSet;
    private BiConsumer<Long, DirectMethodHandleDesc> usingSpecializedUpcallListener;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CAPTURE_CALL_STATE = SnippetRuntime.findForeignCall(ForeignFunctionsRuntime.class, (String)"captureCallState", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});

    @Fold
    public static ForeignFunctionsRuntime singleton() {
        return (ForeignFunctionsRuntime)ImageSingletons.lookup(ForeignFunctionsRuntime.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ForeignFunctionsRuntime(AbiUtils abiUtils) {
        this.trampolineTemplate = abiUtils.generateTrampolineTemplate();
    }

    public static boolean areFunctionCallsSupported() {
        return switch (CABI.current()) {
            case CABI.SYS_V, CABI.WIN_64, CABI.MAC_OS_AARCH_64, CABI.LINUX_AARCH_64 -> true;
            default -> false;
        };
    }

    public static RuntimeException functionCallsUnsupported() {
        assert (SubstrateOptions.isForeignAPIEnabled());
        throw VMError.unsupportedFeature((String)("Calling foreign functions is currently not supported on platform: " + (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase(Locale.ROOT)));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addDowncallStubPointer(NativeEntryPointInfo nep, CFunctionPointer ptr) {
        VMError.guarantee((!this.downcallStubs.containsKey((Object)nep) ? 1 : 0) != 0, (String)"Seems like multiple stubs were generated for %s", (Object)nep);
        VMError.guarantee((this.downcallStubs.put((Object)nep, (Object)new FunctionPointerHolder(ptr)) == null ? 1 : 0) != 0);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addUpcallStubPointer(JavaEntryPointInfo jep, CFunctionPointer ptr) {
        VMError.guarantee((!this.upcallStubs.containsKey((Object)jep) ? 1 : 0) != 0, (String)"Seems like multiple stubs were generated for %s", (Object)jep);
        VMError.guarantee((this.upcallStubs.put((Object)jep, (Object)new FunctionPointerHolder(ptr)) == null ? 1 : 0) != 0);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addDirectUpcallStubPointer(DirectMethodHandleDesc desc, JavaEntryPointInfo jep, CFunctionPointer ptr) {
        Pair key = Pair.create((Object)desc, (Object)jep);
        VMError.guarantee((!this.directUpcallStubs.containsKey((Object)key) ? 1 : 0) != 0, (String)"Seems like multiple stubs were generated for %s", (Object)desc);
        VMError.guarantee((this.directUpcallStubs.put((Object)key, (Object)new FunctionPointerHolder(ptr)) == null ? 1 : 0) != 0);
    }

    CFunctionPointer getDowncallStubPointer(NativeEntryPointInfo nep) {
        FunctionPointerHolder holder = (FunctionPointerHolder)this.downcallStubs.get((Object)nep);
        if (holder == null) {
            throw MissingForeignRegistrationUtils.reportDowncall(nep);
        }
        return holder.functionPointer;
    }

    CFunctionPointer getUpcallStubPointer(JavaEntryPointInfo jep) {
        FunctionPointerHolder holder = (FunctionPointerHolder)this.upcallStubs.get((Object)jep);
        if (holder == null) {
            throw MissingForeignRegistrationUtils.reportUpcall(jep);
        }
        return holder.functionPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pointer registerForUpcall(MethodHandle methodHandle, JavaEntryPointInfo jep) {
        if (!ForeignFunctionsRuntime.areFunctionCallsSupported()) {
            throw ForeignFunctionsRuntime.functionCallsUnsupported();
        }
        CFunctionPointer upcallStubPointer = this.getUpcallStubPointer(jep);
        Map<Long, TrampolineSet> map = this.trampolines;
        synchronized (map) {
            if (this.currentTrampolineSet == null || !this.currentTrampolineSet.hasFreeTrampolines()) {
                this.currentTrampolineSet = new TrampolineSet(this.trampolineTemplate);
                this.trampolines.put(this.currentTrampolineSet.base().rawValue(), this.currentTrampolineSet);
            }
            return this.currentTrampolineSet.assignTrampoline(methodHandle, upcallStubPointer);
        }
    }

    void patchForDirectUpcall(long trampolineAddress, DirectMethodHandleDesc desc, FunctionDescriptor functionDescriptor, LinkerOptions options) {
        JavaEntryPointInfo jep = AbiUtils.singleton().makeJavaEntryPoint(functionDescriptor, options);
        FunctionPointerHolder functionPointerHolder = (FunctionPointerHolder)this.directUpcallStubs.get((Object)Pair.create((Object)desc, (Object)jep));
        if (functionPointerHolder == null) {
            return;
        }
        Pointer trampolinePointer = (Pointer)Word.pointer((long)trampolineAddress);
        Pointer trampolineSetBase = TrampolineSet.getAllocationBase(trampolinePointer);
        TrampolineSet trampolineSet = this.trampolines.get(trampolineSetBase.rawValue());
        if (trampolineSet == null) {
            return;
        }
        trampolineSet.patchTrampolineForDirectUpcall(trampolinePointer, functionPointerHolder.functionPointer);
        if (this.usingSpecializedUpcallListener != null) {
            this.usingSpecializedUpcallListener.accept(trampolineAddress, desc);
        }
    }

    public void setUsingSpecializedUpcallListener(BiConsumer<Long, DirectMethodHandleDesc> listener) {
        this.usingSpecializedUpcallListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeTrampoline(long addr) {
        Map<Long, TrampolineSet> map = this.trampolines;
        synchronized (map) {
            long base = TrampolineSet.getAllocationBase((Pointer)Word.pointer((long)addr)).rawValue();
            TrampolineSet trampolineSet = this.trampolines.get(base);
            if (trampolineSet.tryFree()) {
                this.trampolines.remove(base);
            }
        }
    }

    public Object linkToNative(Object ... args) throws Throwable {
        Target_jdk_internal_foreign_abi_NativeEntryPoint nep = (Target_jdk_internal_foreign_abi_NativeEntryPoint)args[args.length - 1];
        StubPointer pointer = (StubPointer)Word.pointer((long)nep.downcallStubAddress);
        return pointer.invoke(args);
    }

    public void onMemorySegmentReachable(Object memorySegmentObj, DisallowedImageHeapObjects.DisallowedObjectReporter reporter) {
        VMError.guarantee((boolean)(memorySegmentObj instanceof MemorySegment));
        MemorySegment memorySegment = (MemorySegment)memorySegmentObj;
        if (memorySegment.isNative() && !MemorySegment.NULL.equals(memorySegment)) {
            throw reporter.raise("Detected a native MemorySegment in the image heap. A native MemorySegment has a pointer to unmanaged C memory, and C memory from the image generator is not available at image runtime.", (Object)memorySegment, "Try avoiding to initialize the class that called 'MemorySegment.ofAddress'.");
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+21/src/java.base/share/classes/java/lang/foreign/MemorySegment.java#L2708")
    public void onScopeReachable(Object scopeObj, DisallowedImageHeapObjects.DisallowedObjectReporter reporter) {
        MemorySessionImpl memorySessionImpl;
        VMError.guarantee((boolean)(scopeObj instanceof MemorySegment.Scope));
        if (scopeObj instanceof MemorySessionImpl && (memorySessionImpl = (MemorySessionImpl)scopeObj).isAlive() && memorySessionImpl.isCloseable()) {
            throw reporter.raise("Detected an open but closable MemorySegment.Scope in the image heap. A MemorySegment.Scope may have associated unmanaged C memory that will be attempted to be free'd if the scope is closed. However, C memory from the image generator is no longer available at image runtime.", (Object)memorySessionImpl, "Try avoiding to initialize the class that called 'Arena.ofConfined/ofShared'.");
        }
    }

    @Fold
    static int getMask(String state) {
        return CapturableState.maskFromName((String)state);
    }

    @Fold
    static boolean isWindows() {
        return OS.WINDOWS.isCurrent();
    }

    @Uninterruptible(reason="Interruptions might change call state.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+22/src/hotspot/share/prims/downcallLinker.cpp")
    public static void captureCallState(int statesToCapture, CIntPointer captureBuffer) {
        assert (statesToCapture != 0);
        assert (captureBuffer.isNonNull());
        int i = 0;
        if (ForeignFunctionsRuntime.isWindows()) {
            assert (WindowsAPIs.isSupported()) : "Windows APIs should be supported on Windows OS";
            if ((statesToCapture & ForeignFunctionsRuntime.getMask("GetLastError")) != 0) {
                captureBuffer.write(i, WindowsAPIs.getLastError());
            }
            ++i;
            if ((statesToCapture & ForeignFunctionsRuntime.getMask("WSAGetLastError")) != 0) {
                captureBuffer.write(i, WindowsAPIs.wsaGetLastError());
            }
            ++i;
        }
        assert (LibC.isSupported()) : "LibC should always be supported";
        if ((statesToCapture & ForeignFunctionsRuntime.getMask("errno")) != 0) {
            captureBuffer.write(i, LibC.errno());
        }
        ++i;
    }

    public static class MissingForeignRegistrationUtils
    extends MissingRegistrationUtils {
        private static final Map<String, Set<String>> foreignEntryPoints = Map.of("jdk.internal.foreign.abi.AbstractLinker", Set.of("downcallHandle", "upcallStub"));

        public static MissingForeignRegistrationError reportDowncall(NativeEntryPointInfo nep) {
            MissingForeignRegistrationError mfre = new MissingForeignRegistrationError(MissingForeignRegistrationUtils.foreignRegistrationMessage("downcall", nep.methodType()));
            MissingForeignRegistrationUtils.report(mfre);
            return mfre;
        }

        public static MissingForeignRegistrationError reportUpcall(JavaEntryPointInfo jep) {
            MissingForeignRegistrationError mfre = new MissingForeignRegistrationError(MissingForeignRegistrationUtils.foreignRegistrationMessage("upcall", jep.cMethodType()));
            MissingForeignRegistrationUtils.report(mfre);
            return mfre;
        }

        private static String foreignRegistrationMessage(String failedAction, MethodType methodType) {
            return MissingForeignRegistrationUtils.registrationMessage((String)("perform " + failedAction + " with leaf type"), (String)methodType.toString(), (String)"", (String)"", (String)"foreign", (String)"foreign");
        }

        private static void report(MissingForeignRegistrationError exception) {
            StackTraceElement responsibleClass = MissingForeignRegistrationUtils.getResponsibleClass((Throwable)exception, foreignEntryPoints);
            MissingRegistrationUtils.report((Error)exception, (StackTraceElement)responsibleClass);
        }
    }
}

