/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_NativeEntryPoint;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import jdk.internal.foreign.abi.ABIDescriptor;
import jdk.internal.foreign.abi.VMStorage;

public final class NativeEntryPointInfo {
    private final MethodType methodType;
    private final VMStorage[] parameterAssignments;
    private final VMStorage[] returnBuffering;
    private final boolean needsReturnBuffer;
    private final boolean capturesState;
    private final boolean needsTransition;
    private final boolean allowHeapAccess;

    private NativeEntryPointInfo(MethodType methodType, VMStorage[] cc, VMStorage[] returnBuffering, boolean needsReturnBuffer, boolean capturesState, boolean needsTransition, boolean allowHeapAccess) {
        assert (methodType.parameterCount() == cc.length);
        assert (needsReturnBuffer == returnBuffering.length > 1);
        assert (!needsTransition || !allowHeapAccess);
        this.methodType = methodType;
        this.parameterAssignments = cc;
        this.returnBuffering = returnBuffering;
        this.needsReturnBuffer = needsReturnBuffer;
        this.capturesState = capturesState;
        this.needsTransition = needsTransition;
        this.allowHeapAccess = allowHeapAccess;
    }

    public static NativeEntryPointInfo make(VMStorage[] argMoves, VMStorage[] returnMoves, MethodType methodType, boolean needsReturnBuffer, int capturedStateMask, boolean needsTransition, boolean allowHeapAccessParam) {
        if (returnMoves.length > 1 != needsReturnBuffer) {
            throw new AssertionError((Object)"Multiple register return, but needsReturnBuffer was false");
        }
        boolean hasNull = Arrays.stream(argMoves).anyMatch(Objects::isNull);
        VMError.guarantee((!hasNull || allowHeapAccessParam ? 1 : 0) != 0, (String)"null VMStorages should only appear with Linker.Option.critical(true).");
        boolean allowHeapAccess = allowHeapAccessParam;
        if (!hasNull) {
            allowHeapAccess = false;
        }
        return new NativeEntryPointInfo(methodType, argMoves, returnMoves, needsReturnBuffer, capturedStateMask != 0, needsTransition, allowHeapAccess);
    }

    public static Target_jdk_internal_foreign_abi_NativeEntryPoint makeEntryPoint(ABIDescriptor ignoreAbi, VMStorage[] argMoves, VMStorage[] returnMoves, MethodType methodType, boolean needsReturnBuffer, int capturedStateMask, boolean needsTransition, boolean allowHeapAccess) {
        NativeEntryPointInfo info = NativeEntryPointInfo.make(argMoves, returnMoves, methodType, needsReturnBuffer, capturedStateMask, needsTransition, allowHeapAccess);
        long addr = ForeignFunctionsRuntime.singleton().getDowncallStubPointer(info).rawValue();
        return new Target_jdk_internal_foreign_abi_NativeEntryPoint(info.methodType(), addr, capturedStateMask);
    }

    public MethodType methodType() {
        return this.methodType;
    }

    public boolean needsReturnBuffer() {
        return this.needsReturnBuffer;
    }

    public boolean capturesCallState() {
        return this.capturesState;
    }

    public boolean allowHeapAccess() {
        assert (!this.needsTransition || !this.allowHeapAccess);
        return this.allowHeapAccess;
    }

    public VMStorage[] parametersAssignment() {
        return this.parameterAssignments;
    }

    public VMStorage[] returnsAssignment() {
        return this.returnBuffering;
    }

    public boolean skipsTransition() {
        return !this.needsTransition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeEntryPointInfo that = (NativeEntryPointInfo)o;
        return this.capturesState == that.capturesState && this.needsTransition == that.needsTransition && this.needsReturnBuffer == that.needsReturnBuffer && this.allowHeapAccess == that.allowHeapAccess && Objects.equals(this.methodType, that.methodType) && Arrays.equals(this.parameterAssignments, that.parameterAssignments) && Arrays.equals(this.returnBuffering, that.returnBuffering);
    }

    public int hashCode() {
        return Objects.hash(this.methodType, this.needsReturnBuffer, this.capturesState, this.needsTransition, this.allowHeapAccess, Arrays.hashCode(this.parameterAssignments), Arrays.hashCode(this.returnBuffering));
    }
}

