/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.util.ParallelExecutionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.common.JVMCIError;

public class CompletionExecutor {
    private final AtomicReference<State> state;
    private final LongAdder postedOperations;
    private final LongAdder completedOperations;
    private List<DebugContextRunnable> postedBeforeStart;
    private final CopyOnWriteArrayList<Throwable> exceptions = new CopyOnWriteArrayList();
    private final DebugContext debug;
    private final BigBang bb;
    private Timing timing;

    public CompletionExecutor(DebugContext debugContext, BigBang bb) {
        this.debug = debugContext.areScopesEnabled() || debugContext.areMetricsEnabled() ? debugContext : null;
        this.bb = bb;
        this.state = new AtomicReference<State>(State.UNUSED);
        this.postedOperations = new LongAdder();
        this.completedOperations = new LongAdder();
    }

    public void init() {
        this.init(null);
    }

    public void init(Timing newTiming) {
        this.timing = newTiming;
        this.setState(State.BEFORE_START);
        this.postedOperations.reset();
        this.completedOperations.reset();
        this.postedBeforeStart = Collections.synchronizedList(new ArrayList());
    }

    public void execute(DebugContextRunnable command) {
        if (!this.exceptions.isEmpty()) {
            return;
        }
        switch (this.state.get().ordinal()) {
            case 2: {
                throw JVMCIError.shouldNotReachHere();
            }
            case 0: {
                this.postedBeforeStart.add(command);
                break;
            }
            case 1: {
                this.postedOperations.increment();
                if (this.timing != null) {
                    this.timing.addScheduled(command);
                }
                this.executeService(command);
                break;
            }
            default: {
                throw JVMCIError.shouldNotReachHere();
            }
        }
    }

    private void executeService(DebugContextRunnable command) {
        ForkJoinPool.commonPool().execute(() -> this.executeCommand(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(DebugContextRunnable command) {
        long startTime = 0L;
        if (this.timing != null) {
            startTime = System.nanoTime();
        }
        this.bb.getHostVM().recordActivity();
        Throwable thrown = null;
        try (DebugContext localDebug = command.getDebug(this.bb.getOptions(), this.bb.getDebugHandlerFactories());
             DebugContext.Scope s = localDebug.scope((Object)"Operation");
             DebugContext.Activation a = localDebug.activate();){
            command.run(localDebug);
        }
        catch (Throwable x) {
            thrown = x;
        }
        finally {
            this.bb.getHostVM().clearInThread();
            if (this.timing != null) {
                long taskTime = System.nanoTime() - startTime;
                this.timing.addCompleted(command, taskTime);
            }
            if (thrown != null) {
                this.exceptions.add(thrown);
            }
            this.completedOperations.increment();
        }
    }

    public void start() {
        assert (this.state.get() == State.BEFORE_START) : this.state.get();
        this.setState(State.STARTED);
        this.postedBeforeStart.forEach(this::execute);
        this.postedBeforeStart = null;
    }

    private void setState(State newState) {
        this.state.set(newState);
    }

    public long complete() throws InterruptedException {
        long lastPrint = 0L;
        if (this.timing != null) {
            this.timing.printHeader();
            this.timing.print();
            lastPrint = System.nanoTime();
        }
        try {
            do {
                long curTime;
                assert (this.state.get() == State.STARTED) : this.state.get();
                boolean quiescent = ForkJoinPool.commonPool().awaitQuiescence(100L, TimeUnit.MILLISECONDS);
                if (this.timing != null && !quiescent && (curTime = System.nanoTime()) - lastPrint > this.timing.getPrintIntervalNanos()) {
                    this.timing.print();
                    lastPrint = curTime;
                }
                long completed = this.completedOperations.sum();
                long posted = this.postedOperations.sum();
                assert (completed <= posted) : completed + ", " + posted;
                if (completed != posted || !this.exceptions.isEmpty()) continue;
                if (this.timing != null) {
                    this.timing.print();
                }
                long l = posted;
                return l;
            } while (this.exceptions.isEmpty());
            this.setState(State.UNUSED);
            throw new ParallelExecutionException(this.exceptions);
        }
        finally {
            if (this.debug != null) {
                this.debug.closeDumpHandlers(true);
            }
        }
    }

    public long getPostedOperations() {
        return this.postedOperations.sum() + (long)(this.postedBeforeStart == null ? 0 : this.postedBeforeStart.size());
    }

    public void shutdown() {
        assert (!ForkJoinPool.commonPool().hasQueuedSubmissions()) : "There should be no queued submissions on shutdown.";
        assert (this.completedOperations.sum() == this.postedOperations.sum()) : "Posted operations (" + this.postedOperations.sum() + ") must match completed (" + this.completedOperations.sum() + ") operations";
        this.setState(State.UNUSED);
    }

    public boolean isBeforeStart() {
        return this.state.get() == State.BEFORE_START;
    }

    public boolean isStarted() {
        return this.state.get() == State.STARTED;
    }

    public State getState() {
        return this.state.get();
    }

    private static enum State {
        BEFORE_START,
        STARTED,
        UNUSED;

    }

    public static interface Timing {
        public long getPrintIntervalNanos();

        public void addScheduled(DebugContextRunnable var1);

        public void addCompleted(DebugContextRunnable var1, long var2);

        public void printHeader();

        public void print();
    }

    public static interface DebugContextRunnable {
        public void run(DebugContext var1);

        default public DebugContext.Description getDescription() {
            return null;
        }

        default public DebugContext getDebug(OptionValues options, List<DebugHandlersFactory> factories) {
            return DebugContext.disabled(null);
        }
    }
}

