/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.function.Function;
import org.graalvm.nativeimage.hosted.Feature;

public final class NativeObjectReplacer
implements Function<Object, Object> {
    private final IdentityHashMap<Class<?>, Object> disallowedClasses = new IdentityHashMap(16);
    private final Class<?> nativePointer;
    private final Field nativePointerField;

    NativeObjectReplacer(Feature.DuringSetupAccess access) {
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.ClosureNativePointer"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.ClosureNativePointer$NativeDestructor"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.LibFFILibrary"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.LibFFISignature"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.LibFFISymbol"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.LibFFIType"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.NativeAllocation$FreeDestructor"), Boolean.FALSE);
        this.disallowedClasses.put(access.findClassByName("com.oracle.truffle.nfi.backend.libffi.NativeString"), Boolean.FALSE);
        this.nativePointer = access.findClassByName("com.oracle.truffle.nfi.backend.libffi.NativePointer");
        this.disallowedClasses.put(this.nativePointer, Boolean.FALSE);
        try {
            this.nativePointerField = this.nativePointer.getSuperclass().getDeclaredField("nativePointer");
            this.nativePointerField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw VMError.shouldNotReachHere((Throwable)ex);
        }
    }

    @Override
    public Object apply(Object obj) {
        if (obj.getClass() == this.nativePointer) {
            long ptr;
            try {
                ptr = this.nativePointerField.getLong(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw VMError.shouldNotReachHere((Throwable)ex);
            }
            if (ptr == 0L) {
                return obj;
            }
        }
        if (this.disallowedClasses.containsKey(obj.getClass())) {
            throw new UnsupportedFeatureException(String.format("Native object (%s) stored in pre-initialized context.", ClassUtil.getUnqualifiedName(obj.getClass())));
        }
        return obj;
    }
}

