/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.filters;

import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.filters.ConfigurationFilter;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import jdk.graal.compiler.util.json.JsonParserException;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class FilterConfigurationParser
extends ConfigurationParser {
    private final ConfigurationFilter filter;

    public FilterConfigurationParser(ConfigurationFilter filter) {
        super(EnumSet.of(ConfigurationParserOption.STRICT_CONFIGURATION));
        assert (filter != null);
        this.filter = filter;
    }

    static void parseEntry(Object entryObject, BiConsumer<String, ConfigurationFilter.Inclusion> parsedEntryConsumer) {
        EconomicMap<String, Object> entry = FilterConfigurationParser.asMap(entryObject, "Filter entries must be objects");
        Object qualified = null;
        ConfigurationFilter.Inclusion inclusion = null;
        String exactlyOneMessage = "Exactly one of attributes 'includeClasses' and 'excludeClasses' must be specified for a filter entry";
        MapCursor cursor = entry.getEntries();
        while (cursor.advance()) {
            if (qualified != null) {
                throw new JsonParserException(exactlyOneMessage);
            }
            qualified = cursor.getValue();
            if ("includeClasses".equals(cursor.getKey())) {
                inclusion = ConfigurationFilter.Inclusion.Include;
                continue;
            }
            if ("excludeClasses".equals(cursor.getKey())) {
                inclusion = ConfigurationFilter.Inclusion.Exclude;
                continue;
            }
            throw new JsonParserException("Unknown attribute '" + (String)cursor.getKey() + "' (supported attributes: 'includeClasses', 'excludeClasses') in filter");
        }
        if (qualified == null) {
            throw new JsonParserException(exactlyOneMessage);
        }
        parsedEntryConsumer.accept(FilterConfigurationParser.asString(qualified), inclusion);
    }

    static void printEntry(JsonWriter writer, boolean[] isFirstRule, ConfigurationFilter.Inclusion inclusion, String rule) throws IOException {
        if (inclusion == null) {
            return;
        }
        if (!isFirstRule[0]) {
            writer.append(',').newline();
        } else {
            isFirstRule[0] = false;
        }
        writer.append('{');
        switch (inclusion) {
            case Include: {
                writer.quote("includeClasses");
                break;
            }
            case Exclude: {
                writer.quote("excludeClasses");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported inclusion value: " + inclusion.name());
            }
        }
        writer.append(':');
        writer.quote(rule);
        writer.append("}");
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.filter.parseFromJson(FilterConfigurationParser.asMap(json, "First level of document must be an object"));
    }
}

