// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: LibGraalCollectionPolicy.Options.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class LibGraalCollectionPolicy_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(LibGraalCollectionPolicy.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "ExpectedEdenSize": {
            return OptionDescriptor.create(
                /*name*/ "ExpectedEdenSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Soft upper limit for used eden size. The hinted GC will be performed if the used eden size exceeds this value.",
                /*container*/ getContainer(),
                /*option*/ LibGraalCollectionPolicy.Options.ExpectedEdenSize,
                /*fieldName*/ "ExpectedEdenSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UsedEdenProportionThreshold": {
            return OptionDescriptor.create(
                /*name*/ "UsedEdenProportionThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "Ratio of used bytes to total allocated bytes for eden space. Setting it to a smaller value will trade more triggered hinted GCs for less resident set size.",
                /*container*/ getContainer(),
                /*option*/ LibGraalCollectionPolicy.Options.UsedEdenProportionThreshold,
                /*fieldName*/ "UsedEdenProportionThreshold",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 2;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("ExpectedEdenSize");
                    case 1: return get("UsedEdenProportionThreshold");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
