// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: ClassInitializationOptions.java
package com.oracle.svm.hosted.classinitialization;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class ClassInitializationOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(ClassInitializationOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AllowDeprecatedInitializeAllClassesAtBuildTime": {
            return OptionDescriptor.create(
                /*name*/ "AllowDeprecatedInitializeAllClassesAtBuildTime",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instead of abort, only warn if --initialize-at-build-time= is used.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.AllowDeprecatedInitializeAllClassesAtBuildTime,
                /*fieldName*/ "AllowDeprecatedInitializeAllClassesAtBuildTime",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option was introduced to simplify migration to GraalVM 23.0 and will be removed in a future release");
        }
        case "AssertInitializationSpecifiedForAllClasses": {
            return OptionDescriptor.create(
                /*name*/ "AssertInitializationSpecifiedForAllClasses",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Assert class initialization is specified for all classes.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.AssertInitializationSpecifiedForAllClasses,
                /*fieldName*/ "AssertInitializationSpecifiedForAllClasses",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "ClassInitialization",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "A comma-separated list of classes appended with their initialization strategy (':build_time' or ':run_time')",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.ClassInitialization,
                /*fieldName*/ "ClassInitialization",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "PrintClassInitialization",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Prints class initialization info for all classes detected by analysis.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.PrintClassInitialization,
                /*fieldName*/ "PrintClassInitialization",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializer": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializer",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Simulate the effects of class initializer at image build time, to avoid class initialization at run time.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.SimulateClassInitializer,
                /*fieldName*/ "SimulateClassInitializer",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerCollectAllReasons": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerCollectAllReasons",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Configuration for SimulateClassInitializer: Collect all reasons why a class initializer cannot be simulated.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.SimulateClassInitializerCollectAllReasons,
                /*fieldName*/ "SimulateClassInitializerCollectAllReasons",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerMaxAllocatedBytes": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerMaxAllocatedBytes",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Configuration for SimulateClassInitializer: Maximum number of bytes allocated in the image heap for each class initializer.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.SimulateClassInitializerMaxAllocatedBytes,
                /*fieldName*/ "SimulateClassInitializerMaxAllocatedBytes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerMaxInlineDepth": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerMaxInlineDepth",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Configuration for SimulateClassInitializer: Maximum inlining depth during simulation.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.SimulateClassInitializerMaxInlineDepth,
                /*fieldName*/ "SimulateClassInitializerMaxInlineDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerMaxLoopIterations": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerMaxLoopIterations",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Configuration for SimulateClassInitializer: Maximum number of loop iterations that are unrolled during simulation.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.SimulateClassInitializerMaxLoopIterations,
                /*fieldName*/ "SimulateClassInitializerMaxLoopIterations",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "StrictImageHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*container*/ getContainer(),
                /*option*/ ClassInitializationOptions.StrictImageHeap,
                /*fieldName*/ "StrictImageHeap",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 10;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllowDeprecatedInitializeAllClassesAtBuildTime");
                    case 1: return get("AssertInitializationSpecifiedForAllClasses");
                    case 2: return get("ClassInitialization");
                    case 3: return get("PrintClassInitialization");
                    case 4: return get("SimulateClassInitializer");
                    case 5: return get("SimulateClassInitializerCollectAllReasons");
                    case 6: return get("SimulateClassInitializerMaxAllocatedBytes");
                    case 7: return get("SimulateClassInitializerMaxInlineDepth");
                    case 8: return get("SimulateClassInitializerMaxLoopIterations");
                    case 9: return get("StrictImageHeap");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
