/*
 * Copyright (c) 2025, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.svm.hosted.jdk.jniRegistration;

import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.Optional;

import static java.lang.constant.ConstantDescs.CD_boolean;
import static java.lang.constant.ConstantDescs.CD_char;
import static java.lang.constant.ConstantDescs.CD_int;

public class ClassSunFont2DRegistration extends BaseClassMemberRegistration {
    @Override
    public String getClassName() {
        return "sun.font.Font2D";
    }

    @Override
    public List<MethodSignature> getMethods() {
        ClassDesc charToGlyphMapperClassDesc = ClassDesc.of("sun.font.CharToGlyphMapper");
        Optional<ClassDesc> byteArrClassDesc = byte[].class.describeConstable();
        if (byteArrClassDesc.isEmpty()) {
            throw new RuntimeException("byteArrClassDesc is null");
        }

        return List.of(
                new MethodSignature("canDisplay", MethodTypeDesc.of(CD_boolean, CD_char)),
                new MethodSignature("charToGlyph", MethodTypeDesc.of(CD_int, CD_int)),
                new MethodSignature("charToGlyphRaw", MethodTypeDesc.of(CD_int, CD_int)),
                new MethodSignature("charToVariationGlyph", MethodTypeDesc.of(CD_int, CD_int, CD_int)),
                new MethodSignature("charToVariationGlyphRaw", MethodTypeDesc.of(CD_int, CD_int, CD_int)),
                new MethodSignature("getMapper", MethodTypeDesc.of(charToGlyphMapperClassDesc)),
                new MethodSignature("getTableBytes", MethodTypeDesc.of(byteArrClassDesc.get(), CD_int)));
    }
}
