// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: DataSection.Options.java
package jdk.graal.compiler.code;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class DataSection_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(DataSection.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "ForceAdversarialLayout": {
            return OptionDescriptor.create(
                /*name*/ "ForceAdversarialLayout",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Place N-byte constants in the data section such that they are misaligned with respect to N*2. For example, place 4 byte constants at offset 4, 12 or 20, etc. This layout is used to detect instructions that load constants with alignment smaller than the fetch size. For instance, an XORPS instruction that does a 16-byte fetch of a 4-byte float not aligned to 16 bytes will cause a segfault.",
                /*container*/ getContainer(),
                /*option*/ DataSection.Options.ForceAdversarialLayout,
                /*fieldName*/ "ForceAdversarialLayout",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 1;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("ForceAdversarialLayout");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
