/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.FrameId;
import com.oracle.svm.jdwp.bridge.StackFrame;
import com.oracle.svm.jdwp.server.impl.ThreadRef;

public final class CallFrame {
    private final long frameId;
    private final ThreadRef thread;
    private final long classId;
    private final byte typeTag;
    private final long methodId;
    private final long codeIndex;

    public static CallFrame fromStackFrame(ThreadRef threadRef, StackFrame stackFrame) {
        return new CallFrame(threadRef, stackFrame.classId(), stackFrame.typeTag(), stackFrame.methodId(), stackFrame.bci(), stackFrame.frameDepth());
    }

    CallFrame(ThreadRef thread, long classId, byte typeTag, long methodId, long bci, int frameDepth) {
        this.frameId = FrameId.createFrameId((long)thread.getFrameGeneration(), (int)frameDepth);
        this.thread = thread;
        this.classId = classId;
        this.typeTag = typeTag;
        this.methodId = methodId;
        this.codeIndex = bci;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public byte getTypeTag() {
        return this.typeTag;
    }

    public long getClassId() {
        return this.classId;
    }

    public long getMethodId() {
        return this.methodId;
    }

    public long getCodeIndex() {
        return this.codeIndex;
    }

    public long getThreadId() {
        return this.thread.getThreadId();
    }
}

