/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.EventKind;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.WritablePacket;
import com.oracle.svm.jdwp.server.api.BreakpointInfo;
import com.oracle.svm.jdwp.server.api.VMEventListener;
import com.oracle.svm.jdwp.server.impl.ClassPrepareRequest;
import com.oracle.svm.jdwp.server.impl.EventInfo;
import com.oracle.svm.jdwp.server.impl.JDWPContext;
import com.oracle.svm.jdwp.server.impl.RequestFilter;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import com.oracle.svm.jdwp.server.impl.SocketConnection;
import com.oracle.svm.jdwp.server.impl.SteppingInfo;
import com.oracle.svm.jdwp.server.impl.SuspendedInfo;
import com.oracle.svm.jdwp.server.impl.ThreadRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class VMEventListenerImpl
implements VMEventListener {
    private final Map<Integer, ClassPrepareRequest> classPrepareRequests = new ConcurrentHashMap<Integer, ClassPrepareRequest>();
    private final Map<Integer, Collection<BreakpointInfo>> breakpointRequests = new ConcurrentHashMap<Integer, Collection<BreakpointInfo>>();
    private final Map<Integer, SteppingInfo> stepRequests = new ConcurrentHashMap<Integer, SteppingInfo>();
    private final Map<Long, Integer> stepRequestPerThread = new ConcurrentHashMap<Long, Integer>();
    private SocketConnection connection;
    private JDWPContext context;
    private volatile boolean holdEvents;
    private final Object holdEventsLock = new Object();
    private volatile boolean vmDied;
    private int threadStartedRequestId;
    private int threadDeathRequestId;
    private byte threadStartSuspendPolicy;
    private byte threadDeathSuspendPolicy;
    private int vmDeathRequestId;
    private byte vmDeathSuspendPolicy = 0;
    private int vmStartRequestId;
    private long initialThreadId;

    public void activate(long itid, JDWPContext jdwpContext) {
        this.initialThreadId = itid;
        this.context = jdwpContext;
    }

    @Override
    public void setConnection(SocketConnection connection) {
        this.connection = connection;
    }

    @Override
    public void addClassPrepareRequest(ClassPrepareRequest request) {
        this.classPrepareRequests.put(request.getRequestId(), request);
    }

    @Override
    public void removeClassPrepareRequest(int requestId) {
        this.classPrepareRequests.remove(requestId);
    }

    @Override
    public void addBreakpointRequest(int requestId, Collection<BreakpointInfo> infos) {
        this.breakpointRequests.put(requestId, infos);
    }

    @Override
    public void removeBreakpointRequest(int requestId) {
        Collection<BreakpointInfo> remove = this.breakpointRequests.remove(requestId);
        if (remove != null) {
            this.context.getBreakpoints().removeAll(remove);
        }
    }

    @Override
    public void clearAllBreakpointRequests() {
        Iterator<Map.Entry<Integer, Collection<BreakpointInfo>>> entries = this.breakpointRequests.entrySet().iterator();
        while (entries.hasNext()) {
            Collection<BreakpointInfo> infos = entries.next().getValue();
            this.context.getBreakpoints().removeAll(infos);
            entries.remove();
        }
    }

    @Override
    public void addStepRequest(int requestId, long threadId, SteppingInfo info) {
        this.stepRequests.put(requestId, info);
        this.stepRequestPerThread.put(threadId, requestId);
    }

    @Override
    public void removeStepRequest(int requestId) {
        SteppingInfo info = this.stepRequests.remove(requestId);
        if (info != null) {
            long threadId = info.getThreadId();
            this.stepRequestPerThread.remove(threadId);
            ServerJDWP.BRIDGE.setEventEnabled(threadId, EventKind.SINGLE_STEP.ordinal(), false);
        }
    }

    private void clearAllStepRequests() {
        for (SteppingInfo info : this.stepRequests.values()) {
            long threadId = info.getThreadId();
            ServerJDWP.BRIDGE.setEventEnabled(threadId, EventKind.SINGLE_STEP.ordinal(), false);
        }
        this.stepRequests.clear();
        this.stepRequestPerThread.clear();
    }

    public void onEventAt(long threadId, long classId, byte typeTag, long methodId, int bci, byte resultTag, long resultPrimitiveOrId, int eventKindFlags) {
        List<Object> infoList = null;
        byte suspendPolicy = 0;
        ServerJDWP.LOGGER.log(() -> "onEventAt(" + threadId + ", " + methodId + ", " + bci + ", flags=" + eventKindFlags + ")");
        if (EventKind.SINGLE_STEP.matchesFlag(eventKindFlags)) {
            Integer requestId = this.stepRequestPerThread.get(threadId);
            assert (requestId != null);
            SteppingInfo steppingInfo = this.stepRequests.get(requestId);
            Iterator filter = steppingInfo.stepInfo().filter();
            String string = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(classId).toClassName();
            ServerJDWP.BRIDGE.setSteppingFromLocation(threadId, steppingInfo.stepInfo().getInterpreterDepth(), steppingInfo.stepInfo().getInterpreterSize(), methodId, bci, -2);
            if (((RequestFilter)((Object)filter)).isHit(new EventInfo(threadId, classId, string, methodId, bci, steppingInfo.stepRemoval())) && steppingInfo.stepInfo().startLocation().differsAndUpdate(methodId, bci)) {
                ServerJDWP.LOGGER.log(() -> "onStep(" + threadId + ", " + methodId + ", " + bci + ")");
                infoList = Collections.singletonList(steppingInfo);
                suspendPolicy = (byte)Math.max(suspendPolicy, steppingInfo.suspendPolicy());
            }
        }
        for (Collection collection : this.breakpointRequests.values()) {
            for (BreakpointInfo breakpointInfo : collection) {
                EventKind eventKind = breakpointInfo.getEventKind();
                ServerJDWP.LOGGER.log(() -> "  info: " + String.valueOf(info) + " of " + String.valueOf(eventKind) + " matches " + eventKindFlags + " = " + eventKind.matchesFlag(eventKindFlags));
                if (!eventKind.matchesFlag(eventKindFlags) || !breakpointInfo.matches(classId, methodId, bci)) continue;
                ResolvedJavaMethod method = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaMethod(methodId);
                String className = method.getDeclaringClass().toClassName();
                if (!breakpointInfo.getFilter().isHit(new EventInfo(threadId, classId, className, methodId, bci, breakpointInfo.getBreakRemoval()))) continue;
                ServerJDWP.LOGGER.log(() -> "onBreakpoint(" + threadId + ", " + methodId + " (" + String.valueOf(method) + "), " + bci + ")");
                infoList = VMEventListenerImpl.addInfo(infoList, breakpointInfo);
                suspendPolicy = (byte)Math.max(suspendPolicy, breakpointInfo.getSuspendPolicy());
            }
        }
        if (infoList != null) {
            WritablePacket packet = WritablePacket.commandPacket();
            Packet.Writer writer = packet.dataWriter();
            writer.writeByte((int)suspendPolicy);
            writer.writeInt(infoList.size());
            for (Object e : infoList) {
                boolean provideResult = false;
                if (e instanceof SteppingInfo) {
                    SteppingInfo si = (SteppingInfo)e;
                    writer.writeByte((int)EventKind.SINGLE_STEP.getEventId());
                    writer.writeInt(si.requestId());
                } else if (e instanceof BreakpointInfo) {
                    BreakpointInfo bi = (BreakpointInfo)e;
                    writer.writeByte((int)bi.getEventKind().getEventId());
                    writer.writeInt(bi.getRequestId());
                    provideResult = EventKind.METHOD_EXIT_WITH_RETURN_VALUE == bi.getEventKind();
                }
                writer.writeLong(threadId);
                writer.writeByte((int)typeTag);
                writer.writeLong(classId);
                writer.writeLong(methodId);
                writer.writeLong((long)bci);
                if (!provideResult) continue;
                VMEventListenerImpl.writeValue(resultTag, resultPrimitiveOrId, writer);
            }
            ThreadRef threadRef = this.context.getThreadRef(threadId);
            Runnable runnable = this.eventSender((Packet)packet);
            SuspendedInfo suspendedInfo = new SuspendedInfo(this.context, threadRef, classId, methodId, bci, -1);
            this.suspend(suspendPolicy, suspendedInfo, runnable);
        }
    }

    private static void writeValue(byte resultTag, long resultPrimitiveOrId, Packet.Writer data) {
        data.writeByte((int)resultTag);
        switch (resultTag) {
            case 66: 
            case 90: {
                data.writeByte((int)((byte)resultPrimitiveOrId));
                break;
            }
            case 67: 
            case 83: {
                data.writeShort((short)resultPrimitiveOrId);
                break;
            }
            case 70: 
            case 73: {
                data.writeInt((int)resultPrimitiveOrId);
                break;
            }
            case 86: {
                break;
            }
            default: {
                data.writeLong(resultPrimitiveOrId);
            }
        }
    }

    private static List<Object> addInfo(List<Object> infoListArgument, Object info) {
        List<Object> infoList = infoListArgument;
        if (infoList == null) {
            return Collections.singletonList(info);
        }
        if (infoList.size() == 1) {
            infoList = new ArrayList<Object>(infoList);
        }
        infoList.add(info);
        return infoList;
    }

    public void onThreadStart(long threadId) {
        if (this.connection == null || this.threadStartedRequestId == 0) {
            return;
        }
        WritablePacket packet = WritablePacket.commandPacket();
        Packet.Writer data = packet.dataWriter();
        data.writeByte((int)this.threadStartSuspendPolicy);
        data.writeInt(1);
        data.writeByte((int)EventKind.THREAD_START.getEventId());
        data.writeInt(this.threadStartedRequestId);
        data.writeLong(threadId);
        this.context.getThreadsCollector().blockIfVMSuspended();
        ServerJDWP.LOGGER.log(() -> "sending thread started event for thread: " + threadId);
        ThreadRef threadRef = this.context.getThreadRef(threadId);
        SuspendedInfo suspendedInfo = new SuspendedInfo(this.context, threadRef, -1L, -1L, -1L, 0);
        this.suspend(this.threadStartSuspendPolicy, suspendedInfo, this.eventSender((Packet)packet));
    }

    public void onThreadDeath(long threadId) {
        if (this.connection == null || this.threadDeathRequestId == 0) {
            return;
        }
        WritablePacket packet = WritablePacket.commandPacket();
        Packet.Writer data = packet.dataWriter();
        byte suspendPolicy = this.threadDeathSuspendPolicy;
        data.writeByte((int)suspendPolicy);
        data.writeInt(1);
        data.writeByte((int)EventKind.THREAD_DEATH.getEventId());
        data.writeInt(this.threadDeathRequestId);
        data.writeLong(threadId);
        this.context.getThreadsCollector().blockIfVMSuspended();
        ServerJDWP.LOGGER.log(() -> "sending thread death event for thread: " + threadId);
        if (this.vmDied && suspendPolicy == 2) {
            suspendPolicy = 1;
        }
        ThreadRef threadRef = this.context.getThreadRef(threadId);
        SuspendedInfo suspendedInfo = new SuspendedInfo(this.context, threadRef, -1L, -1L, -1L, 0);
        this.suspend(suspendPolicy, suspendedInfo, this.eventSender((Packet)packet));
    }

    @Override
    public void vmStarted(boolean suspend) {
        WritablePacket packet = WritablePacket.commandPacket();
        Packet.Writer data = packet.dataWriter();
        data.writeByte(suspend ? 2 : 0);
        data.writeInt(1);
        data.writeByte((int)EventKind.VM_START.getEventId());
        data.writeInt(this.vmStartRequestId != -1 ? this.vmStartRequestId : 0);
        data.writeLong(this.initialThreadId);
        this.eventSender((Packet)packet).run();
    }

    public void onVMDeath() {
        this.vmDied = true;
        if (this.connection == null) {
            return;
        }
        WritablePacket packet = WritablePacket.commandPacket();
        Packet.Writer data = packet.dataWriter();
        data.writeByte((int)this.vmDeathSuspendPolicy);
        if (this.vmDeathRequestId != 0) {
            data.writeInt(2);
            data.writeByte((int)EventKind.VM_DEATH.getEventId());
            data.writeInt(this.vmDeathRequestId);
        } else {
            data.writeInt(1);
        }
        data.writeByte((int)EventKind.VM_DEATH.getEventId());
        data.writeInt(0);
        this.connection.sendVMDied((Packet)packet);
        if (this.vmDeathSuspendPolicy != 0) {
            this.context.getThreadsCollector().releaseAllThreadsAndDispose();
        }
    }

    @Override
    public void addClassUnloadRequestId(int id) {
        ServerJDWP.LOGGER.log(() -> "class unload events not yet implemented!");
    }

    @Override
    public void addThreadStartedRequestId(int id, byte suspendPolicy) {
        ServerJDWP.LOGGER.log(() -> "Adding thread start listener");
        this.threadStartedRequestId = id;
        this.threadStartSuspendPolicy = suspendPolicy;
    }

    @Override
    public void addThreadDiedRequestId(int id, byte suspendPolicy) {
        ServerJDWP.LOGGER.log(() -> "Adding thread death listener");
        this.threadDeathRequestId = id;
        this.threadDeathSuspendPolicy = suspendPolicy;
    }

    @Override
    public void removeThreadStartedRequestId() {
        this.threadStartSuspendPolicy = 0;
        this.threadStartedRequestId = 0;
    }

    @Override
    public void removeThreadDiedRequestId() {
        this.threadDeathSuspendPolicy = 0;
        this.threadDeathRequestId = 0;
    }

    @Override
    public void addVMDeathRequest(int id, byte suspendPolicy) {
        this.vmDeathRequestId = id;
        this.vmDeathSuspendPolicy = suspendPolicy;
    }

    @Override
    public void addVMStartRequest(int id) {
        this.vmStartRequestId = id;
    }

    @Override
    public void holdEvents() {
        this.holdEvents = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseEvents() {
        this.holdEvents = false;
        Object object = this.holdEventsLock;
        synchronized (object) {
            this.holdEventsLock.notifyAll();
        }
    }

    @Override
    public void sendEvent(Packet packet) {
        Objects.requireNonNull(packet);
        this.connection.queuePacket(packet);
    }

    private Runnable eventSender(Packet packet) {
        return () -> {
            if (this.connection == null) {
                return;
            }
            if (this.holdEvents) {
                Object object = this.holdEventsLock;
                synchronized (object) {
                    while (this.holdEvents) {
                        try {
                            this.holdEventsLock.wait();
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
            this.connection.queuePacket(packet);
        };
    }

    private void suspend(byte suspendPolicy, SuspendedInfo suspendedInfo, Runnable eventSender) {
        ServerJDWP.LOGGER.log(() -> "VMEventListenerImpl.suspend(" + suspendPolicy + ", " + String.valueOf(suspendedInfo) + ") thread = " + suspendedInfo.thread().getThreadId());
        if (0 == suspendPolicy) {
            eventSender.run();
        } else {
            ThreadRef threadRef = suspendedInfo.thread();
            if (1 == suspendPolicy) {
                threadRef.suspendedAt(suspendedInfo, eventSender);
            } else {
                assert (2 == suspendPolicy);
                this.context.getThreadsCollector().suspendAllAt(threadRef, suspendedInfo, eventSender);
            }
        }
    }

    @Override
    public void disposeAllRequests() {
        this.classPrepareRequests.clear();
        this.clearAllBreakpointRequests();
        this.clearAllStepRequests();
        ServerJDWP.BRIDGE.setThreadRequest(false, false);
    }
}

