/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaField;

public class NewInstanceTypeFlow
extends TypeFlow<BytecodePosition> {
    private static final AtomicReferenceFieldUpdater<NewInstanceTypeFlow, ConcurrentMap> HEAP_OBJECTS_CACHE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(NewInstanceTypeFlow.class, ConcurrentMap.class, "heapObjectsCache");
    private final boolean insertDefaultFieldValues;
    volatile ConcurrentMap<AnalysisContext, AnalysisObject> heapObjectsCache;

    public NewInstanceTypeFlow(BytecodePosition position, AnalysisType type, boolean insertDefaultFieldValues) {
        super(position, type, TypeState.forEmpty());
        this.insertDefaultFieldValues = insertDefaultFieldValues;
        assert (this.source != null);
    }

    @Override
    protected void onFlowEnabled(PointsToAnalysis bb) {
        super.onFlowEnabled(bb);
        this.declaredType.registerAsInstantiated(this.source);
        if (this.insertDefaultFieldValues) {
            for (ResolvedJavaField f : this.declaredType.getInstanceFields(true)) {
                AnalysisField field = (AnalysisField)f;
                field.getInitialFlow().addState(bb, TypeState.defaultValueForKind(bb, field.getStorageKind()));
            }
        }
    }

    @Override
    public void initFlow(PointsToAnalysis bb) {
        if (!this.isClone()) {
            this.addState(bb, TypeState.forExactType(bb, this.declaredType, false));
        }
    }

    @Override
    public boolean needsInitialization() {
        return true;
    }

    NewInstanceTypeFlow(PointsToAnalysis bb, NewInstanceTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows, original.createCloneState(bb, methodFlows));
        this.insertDefaultFieldValues = original.insertDefaultFieldValues;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new NewInstanceTypeFlow(bb, this, methodFlows);
    }

    TypeState createCloneState(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        AnalysisContext allocationContext = bb.analysisPolicy().allocationContext(bb, methodFlows);
        if (bb.analysisPolicy().isContextSensitiveAllocation(bb, this.declaredType, allocationContext)) {
            AnalysisObject newHeapObject = this.createHeapObject(bb, allocationContext);
            return TypeState.forNonNullObject(bb, newHeapObject);
        }
        return TypeState.forExactType(bb, this.declaredType, false);
    }

    private AnalysisObject createHeapObject(PointsToAnalysis bb, AnalysisContext objContext) {
        AnalysisObject result;
        if (this.heapObjectsCache == null) {
            HEAP_OBJECTS_CACHE_UPDATER.compareAndSet(this, null, new ConcurrentHashMap());
        }
        if ((result = (AnalysisObject)this.heapObjectsCache.get(objContext)) == null) {
            AnalysisObject newValue = bb.analysisPolicy().createHeapObject(bb, this.declaredType, (BytecodePosition)this.source, objContext);
            AnalysisObject oldValue = this.heapObjectsCache.putIfAbsent(objContext, newValue);
            result = oldValue != null ? oldValue : newValue;
        }
        return result;
    }

    @Override
    public String toString() {
        return "NewInstanceFlow<" + this.getStateDescription() + ">";
    }
}

