/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.dcmd.DCmdOption;
import com.oracle.svm.core.heap.dump.HeapDumping;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/hotspot/share/services/diagnosticCommand.hpp#L262-L283")
public class GCHeapDumpDCmd
extends AbstractDCmd {
    private static final DCmdOption<String> FILENAME = new DCmdOption<Object>(String.class, "filename", "File path of where to put the heap dump", true, null);
    private static final DCmdOption<Boolean> DUMP_ALL = new DCmdOption<Boolean>(Boolean.class, "-all", "Dump all objects, including unreachable objects", false, false);
    private static final DCmdOption<Boolean> OVERWRITE = new DCmdOption<Boolean>(Boolean.class, "-overwrite", "If specified, the dump file will be overwritten if it exists", false, false);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public GCHeapDumpDCmd() {
        super("GC.heap_dump", "Generate a HPROF format dump of the Java heap.", DCmd.Impact.High, new DCmdOption[]{FILENAME}, new DCmdOption[]{DUMP_ALL, OVERWRITE});
    }

    @Override
    public String execute(DCmdArguments args) throws Throwable {
        String path = args.get(FILENAME);
        boolean gcBefore = args.get(DUMP_ALL) == false;
        boolean overwrite = args.get(OVERWRITE);
        HeapDumping.singleton().dumpHeap(path, gcBefore, overwrite);
        return "Dumped to: " + path;
    }
}

