/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.VM;
import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/hotspot/share/services/diagnosticCommand.hpp#L59-L68")
public class VMVersionDmd
extends AbstractDCmd {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMVersionDmd() {
        super("VM.version", "Print JVM version information.", DCmd.Impact.Low);
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticCommand.cpp#L234-L246")
    public String execute(DCmdArguments args) throws Throwable {
        VM vm = (VM)ImageSingletons.lookup(VM.class);
        return vm.formattedVmVersion + System.lineSeparator() + vm.formattedJdkVersion;
    }
}

