/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkLogging;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.TlabOptionCache;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.JavaSpinLockUtils;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class HeapAllocation {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long LOCK_OFFSET = UNSAFE.objectFieldOffset(HeapAllocation.class, "lock");
    private volatile int lock;
    private AlignedHeapChunk.AlignedHeader currentChunk;
    private AlignedHeapChunk.AlignedHeader retainedChunk;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapAllocation() {
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/g1/g1CollectedHeap.cpp#L383-L390")
    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    public Pointer allocateNewTlab(UnsignedWord minSize, UnsignedWord requestedSize, WordPointer actualSize) {
        assert (HeapAllocation.fitsInAlignedChunk(requestedSize)) : "We do not allow TLABs larger than an aligned chunk.";
        return this.attemptAllocation(minSize, requestedSize, actualSize);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/g1/g1CollectedHeap.cpp#L392-L402")
    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    public Pointer allocateOutsideTlab(UnsignedWord size) {
        assert (HeapAllocation.fitsInAlignedChunk(size)) : "Must not be called for allocation requests that require an unaligned chunk.";
        WordPointer actualSize = (WordPointer)StackValue.get(WordPointer.class);
        Pointer result = this.attemptAllocation(size, size, actualSize);
        assert (actualSize.read() == size);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+15/src/hotspot/share/gc/g1/g1Allocator.inline.hpp#L52-L62"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/g1/g1AllocRegion.inline.hpp#L89-L95")})
    @Uninterruptible(reason="Returns uninitialized memory and acquires a lock without a thread state transition.", callerMustBe=true)
    private Pointer attemptAllocation(UnsignedWord minSize, UnsignedWord requestedSize, WordPointer actualSize) {
        Pointer result = HeapAllocation.attemptAllocationParallel(this.retainedChunk, minSize, requestedSize, actualSize);
        if (result.isNonNull()) {
            return result;
        }
        result = HeapAllocation.attemptAllocationParallel(this.currentChunk, minSize, requestedSize, actualSize);
        if (result.isNonNull()) {
            return result;
        }
        JavaSpinLockUtils.lockNoTransition(this, LOCK_OFFSET);
        try {
            result = HeapAllocation.attemptAllocationParallel(this.retainedChunk, minSize, requestedSize, actualSize);
            if (result.isNonNull()) {
                Pointer pointer = result;
                return pointer;
            }
            result = HeapAllocation.attemptAllocationParallel(this.currentChunk, minSize, requestedSize, actualSize);
            if (result.isNonNull()) {
                Pointer pointer = result;
                return pointer;
            }
            Pointer pointer = this.attemptAllocationInNewChunk(requestedSize, actualSize);
            return pointer;
        }
        finally {
            JavaSpinLockUtils.unlock(this, LOCK_OFFSET);
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+4/src/hotspot/share/gc/g1/g1AllocRegion.inline.hpp#L51-L65")
    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    private static Pointer attemptAllocationParallel(AlignedHeapChunk.AlignedHeader chunk, UnsignedWord minSize, UnsignedWord requestedSize, WordPointer actualSize) {
        if (chunk.isNonNull()) {
            return HeapAllocation.allocateParallel(chunk, minSize, requestedSize, actualSize);
        }
        return (Pointer)Word.nullPointer();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/g1/g1AllocRegion.inline.hpp#L97-L109")
    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    private Pointer attemptAllocationInNewChunk(UnsignedWord requestedSize, WordPointer actualSize) {
        assert (JavaSpinLockUtils.isLocked(this, LOCK_OFFSET));
        this.retainAllocChunk();
        Pointer result = this.newAllocChunkAndAllocate(requestedSize);
        actualSize.write((WordBase)requestedSize);
        return result;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/g1/g1AllocRegion.cpp#L289-L311")
    @Uninterruptible(reason="Modifies allocation chunks.")
    private void retainAllocChunk() {
        assert (JavaSpinLockUtils.isLocked(this, LOCK_OFFSET));
        if (this.currentChunk.isNonNull() && this.shouldRetain()) {
            this.retainedChunk = this.currentChunk;
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/g1/g1AllocRegion.cpp#L275-L287")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean shouldRetain() {
        UnsignedWord minTlabSize;
        assert (JavaSpinLockUtils.isLocked(this, LOCK_OFFSET));
        UnsignedWord freeBytes = HeapChunk.availableObjectMemory(this.currentChunk);
        if (freeBytes.belowThan(minTlabSize = Word.unsigned((long)TlabOptionCache.singleton().getMinTlabSize()))) {
            return false;
        }
        return this.retainedChunk.isNull() || freeBytes.aboveOrEqual(HeapChunk.availableObjectMemory(this.retainedChunk));
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+4/src/hotspot/share/gc/g1/g1AllocRegion.cpp#L130-L154")
    @Uninterruptible(reason="Returns uninitialized memory.", callerMustBe=true)
    private Pointer newAllocChunkAndAllocate(UnsignedWord requestedSize) {
        assert (JavaSpinLockUtils.isLocked(this, LOCK_OFFSET));
        AlignedHeapChunk.AlignedHeader newChunk = HeapAllocation.requestNewAlignedChunk();
        if (newChunk.isNonNull()) {
            Pointer result = AlignedHeapChunk.allocateMemory(newChunk, requestedSize);
            assert (result.isNonNull());
            HeapChunk.setNext(newChunk, this.currentChunk);
            MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.STORE_STORE);
            this.currentChunk = newChunk;
            return result;
        }
        return (Pointer)Word.nullPointer();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+4/src/hotspot/share/gc/g1/g1HeapRegion.inline.hpp#L186-L208")
    @Uninterruptible(reason="Returns uninitialized memory, modifies alloc chunk.", callerMustBe=true)
    private static Pointer allocateParallel(AlignedHeapChunk.AlignedHeader chunk, UnsignedWord minSize, UnsignedWord requestedSize, WordPointer actualSize) {
        UnsignedWord wantToAllocate;
        Pointer newTop;
        Pointer top;
        do {
            top = (Pointer)chunk.getTopOffset(HeapChunk.CHUNK_HEADER_TOP_IDENTITY);
            UnsignedWord available = chunk.getEndOffset().subtract((UnsignedWord)top);
            wantToAllocate = UnsignedUtils.min(available, requestedSize);
            if (wantToAllocate.belowThan(minSize)) {
                return (Pointer)Word.nullPointer();
            }
            newTop = top.add(wantToAllocate);
            ObjectLayout ol = ConfigurationValues.getObjectLayout();
            assert (ol.isAligned(top.rawValue()) && ol.isAligned(newTop.rawValue()));
        } while (!((Pointer)chunk).logicCompareAndSwapWord(HeapChunk.Header.offsetOfTopOffset(), (WordBase)top, (WordBase)newTop, HeapChunk.CHUNK_HEADER_TOP_IDENTITY));
        actualSize.write((WordBase)wantToAllocate);
        return HeapChunk.asPointer(chunk).add((UnsignedWord)top);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static AlignedHeapChunk.AlignedHeader requestNewAlignedChunk() {
        AlignedHeapChunk.AlignedHeader newChunk = HeapImpl.getChunkProvider().produceAlignedChunk();
        HeapImpl.getAccounting().increaseEdenUsedBytes(HeapParameters.getAlignedHeapChunkSize());
        return newChunk;
    }

    public void retireChunksToEden() {
        VMOperation.guaranteeInProgressAtSafepoint("HeapAllocation.retireChunksToEden");
        AlignedHeapChunk.AlignedHeader chunk = this.currentChunk;
        this.currentChunk = (AlignedHeapChunk.AlignedHeader)Word.nullPointer();
        this.retainedChunk = (AlignedHeapChunk.AlignedHeader)Word.nullPointer();
        Space eden = HeapImpl.getHeapImpl().getYoungGeneration().getEden();
        while (chunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader next = HeapChunk.getNext(chunk);
            HeapChunk.setNext(chunk, (AlignedHeapChunk.AlignedHeader)Word.nullPointer());
            eden.appendAlignedHeapChunk(chunk, null);
            chunk = next;
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23-ga/src/hotspot/share/gc/g1/g1Allocator.cpp#L184-L203")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord unsafeMaxTlabAllocSize() {
        UnsignedWord maxTlabSize = AlignedHeapChunk.getUsableSizeForObjects();
        UnsignedWord minTlabSize = Word.unsigned((long)TlabOptionCache.singleton().getMinTlabSize());
        if (this.currentChunk.isNull() || HeapChunk.availableObjectMemory(this.currentChunk).belowThan(minTlabSize)) {
            return maxTlabSize;
        }
        return UnsignedUtils.min(HeapChunk.availableObjectMemory(this.currentChunk), maxTlabSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean fitsInAlignedChunk(UnsignedWord size) {
        return size.belowOrEqual(AlignedHeapChunk.getUsableSizeForObjects());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void tearDown() {
        HeapChunkProvider.freeAlignedChunkList(this.currentChunk);
        this.currentChunk = (AlignedHeapChunk.AlignedHeader)Word.nullPointer();
        this.retainedChunk = (AlignedHeapChunk.AlignedHeader)Word.nullPointer();
    }

    boolean printLocationInfo(Log log, Pointer ptr) {
        AlignedHeapChunk.AlignedHeader chunk = this.currentChunk;
        while (chunk.isNonNull()) {
            if (HeapChunk.asPointer(chunk).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)HeapChunk.getEndPointer(chunk))) {
                boolean unusablePart = ptr.aboveOrEqual((UnsignedWord)HeapChunk.getTopPointer(chunk));
                HeapAllocation.printChunkInfo(log, chunk, unusablePart);
                return true;
            }
            chunk = HeapChunk.getNext(chunk);
        }
        return false;
    }

    private static void printChunkInfo(Log log, AlignedHeapChunk.AlignedHeader chunk, boolean unusablePart) {
        String unusable = unusablePart ? "unusable part of " : "";
        log.string("points into ").string(unusable).string("heap allocation aligned chunk").spaces(1).zhex((WordBase)chunk).spaces(1);
    }

    void logChunks(Log log, String spaceName) {
        HeapChunkLogging.logChunks(log, this.currentChunk, spaceName, false);
    }
}

