/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.amd64.AMD64CopyLongsNode;
import java.lang.reflect.Type;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.AMD64.class})
public class SubstrateAMD64GraphBuilderPlugins
implements InternalFeature {
    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (!SubstrateOptions.useLLVMBackend()) {
            InvocationPlugins invocationPlugins = plugins.getInvocationPlugins();
            SubstrateAMD64GraphBuilderPlugins.registerCopyLongsPlugin(invocationPlugins);
        }
    }

    private static void registerCopyLongsPlugin(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.svm.core.UnmanagedMemoryUtil");
        r.register(new InvocationPlugin("copyLongsForward", new Type[]{Pointer.class, Pointer.class, UnsignedWord.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode dst, ValueNode size) {
                b.add((Node)AMD64CopyLongsNode.forward(src, dst, size));
                return true;
            }
        });
        r.register(new InvocationPlugin("copyLongsBackward", new Type[]{Pointer.class, Pointer.class, UnsignedWord.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode dst, ValueNode size) {
                b.add((Node)AMD64CopyLongsNode.backward(src, dst, size));
                return true;
            }
        });
    }
}

