/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ValueKind;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class FarReturnNode
extends ControlSinkNode
implements LIRLowerable {
    public static final NodeClass<FarReturnNode> TYPE = NodeClass.create(FarReturnNode.class);
    @Node.Input
    protected ValueNode result;
    @Node.Input
    protected ValueNode sp;
    @Node.Input
    protected ValueNode ip;
    private final boolean fromMethodWithCalleeSavedRegisters;

    public FarReturnNode(ValueNode result, ValueNode sp, ValueNode ip, boolean fromMethodWithCalleeSavedRegisters) {
        super(TYPE, StampFactory.forVoid());
        this.result = result;
        this.sp = sp;
        this.ip = ip;
        this.fromMethodWithCalleeSavedRegisters = fromMethodWithCalleeSavedRegisters;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGenerator lirGenTool = (LIRGenerator)gen.getLIRGeneratorTool();
        AllocatableValue resultOperand = lirGenTool.resultOperandFor(this.result.getStackKind(), (ValueKind)LIRKind.fromJavaKind((Architecture)lirGenTool.target().arch, (JavaKind)this.result.getStackKind()));
        lirGenTool.emitMove(resultOperand, gen.operand((Node)this.result));
        ((SubstrateLIRGenerator)lirGenTool).emitFarReturn(resultOperand, gen.operand((Node)this.sp), gen.operand((Node)this.ip), this.fromMethodWithCalleeSavedRegisters);
    }
}

