/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class WriteReturnAddressNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<WriteReturnAddressNode> TYPE = NodeClass.create(WriteReturnAddressNode.class);
    @Node.Input
    protected ValueNode value;

    protected WriteReturnAddressNode(ValueNode value) {
        super(TYPE, StampFactory.forVoid());
        this.value = value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        TargetDescription target = gen.getLIRGeneratorTool().target();
        assert (target.arch.getReturnAddressSize() > 0);
        LIRKind wordKind = LIRKind.fromJavaKind((Architecture)target.arch, (JavaKind)target.wordJavaKind);
        gen.getLIRGeneratorTool().emitMove((AllocatableValue)StackSlot.get((ValueKind)wordKind, (int)(-target.arch.getReturnAddressSize()), (boolean)true), gen.operand((Node)this.value));
    }

    @Node.NodeIntrinsic
    public static native void writeReturnAddress(Pointer var0);
}

