/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.graal.nodes.DeoptSourcePositionInfoNode;
import java.util.ArrayList;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.DynamicDeoptimizeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.Phase;

public class CollectDeoptimizationSourcePositionsPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        ArrayList<NodeSourcePosition> deoptimzationSourcePositions = new ArrayList<NodeSourcePosition>();
        deoptimzationSourcePositions.add(null);
        for (DeoptimizeNode node : graph.getNodes(DeoptimizeNode.TYPE)) {
            node.setDebugId(deoptimzationSourcePositions.size());
            deoptimzationSourcePositions.add(node.getNodeSourcePosition());
        }
        assert (graph.getNodes(DynamicDeoptimizeNode.TYPE).isEmpty()) : "must collect NodeSourcePosition before DeoptimizationGroupingPhase";
        graph.addAfterFixed((FixedWithNextNode)graph.start(), (FixedNode)graph.add((Node)new DeoptSourcePositionInfoNode(deoptimzationSourcePositions)));
    }
}

