/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.AnalyzeJavaHomeAccessEnabled;
import com.oracle.svm.core.NeverInlineTrivial;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

@TargetClass(value=System.class)
final class Target_java_lang_System {
    @Alias
    private static PrintStream out;
    @Alias
    private static PrintStream err;
    @Alias
    private static InputStream in;
    @Delete
    private static Properties props;

    Target_java_lang_System() {
    }

    @Substitute
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+20/src/java.base/share/native/libjava/System.c#L39-L53")
    private static void registerNatives() {
    }

    @Substitute
    private static void setIn(InputStream is) {
        in = is;
    }

    @Substitute
    private static void setOut(PrintStream ps) {
        out = ps;
    }

    @Substitute
    private static void setErr(PrintStream ps) {
        err = ps;
    }

    @Substitute
    private static int identityHashCode(Object obj) {
        throw VMError.shouldNotReachHere("Intrinsified in SubstrateGraphBuilderPlugins");
    }

    @Substitute
    private static Properties getProperties() {
        return SystemPropertiesSupport.singleton().getCurrentProperties();
    }

    @Substitute
    private static void setProperties(Properties props) {
        SystemPropertiesSupport.singleton().setCurrentProperties(props);
    }

    @Substitute
    public static String setProperty(String key, String value) {
        Target_java_lang_System.checkKey(key);
        return SystemPropertiesSupport.singleton().setCurrentProperty(key, value);
    }

    @Substitute
    @NeverInlineTrivial(reason="Used in 'java.home' access analysis: AnalyzeJavaHomeAccessPhase", onlyWith={AnalyzeJavaHomeAccessEnabled.class})
    private static String getProperty(String key) {
        Target_java_lang_System.checkKey(key);
        return SystemPropertiesSupport.singleton().getCurrentProperty(key);
    }

    @Substitute
    public static String clearProperty(String key) {
        Target_java_lang_System.checkKey(key);
        return SystemPropertiesSupport.singleton().clearCurrentProperty(key);
    }

    @Substitute
    @NeverInlineTrivial(reason="Used in 'java.home' access analysis: AnalyzeJavaHomeAccessPhase", onlyWith={AnalyzeJavaHomeAccessEnabled.class})
    private static String getProperty(String key, String def) {
        Target_java_lang_System.checkKey(key);
        return SystemPropertiesSupport.singleton().getCurrentProperty(key, def);
    }

    @Alias
    private static native void checkKey(String var0);
}

