/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.util.LocaleUtil;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.spi.LocaleServiceProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.util.locale.provider.LocaleProviderAdapter;

public class OptimizedLocalizationSupport
extends LocalizationSupport {
    public final Map<AdaptersByClassKey, LocaleProviderAdapter> adaptersByClass = new HashMap<AdaptersByClassKey, LocaleProviderAdapter>();
    public final Map<LocaleProviderAdapter.Type, LocaleProviderAdapter> adaptersByType = new HashMap<LocaleProviderAdapter.Type, LocaleProviderAdapter>();
    public final Map<Class<? extends LocaleServiceProvider>, Object> providerPools = new HashMap<Class<? extends LocaleServiceProvider>, Object>();
    final Map<BundleCacheKey, ResourceBundle> resourceBundles = new HashMap<BundleCacheKey, ResourceBundle>();
    private final Field bundleNameField = ReflectionUtil.lookupField(ResourceBundle.class, (String)"name");
    private final Field bundleLocaleField = ReflectionUtil.lookupField(ResourceBundle.class, (String)"locale");

    public OptimizedLocalizationSupport(Set<Locale> locales, Charset defaultCharset) {
        super(locales, defaultCharset);
    }

    @Override
    public boolean optimizedMode() {
        return true;
    }

    public ResourceBundle getCached(String baseName, Locale locale) throws MissingResourceException {
        for (Locale candidateLocale : this.control.getCandidateLocales(baseName, locale)) {
            ResourceBundle result = this.resourceBundles.get(new BundleCacheKey(baseName, candidateLocale));
            if (result == null) continue;
            return result;
        }
        String errorMessage = "Resource bundle not found " + baseName + ", locale " + String.valueOf(locale) + ". Register the resource bundle using the option -H:IncludeResourceBundles=" + baseName + ".";
        throw new MissingResourceException(errorMessage, this.getClass().getName(), baseName);
    }

    @Override
    public void prepareClassResourceBundle(String basename, Class<?> bundleClass) {
        try {
            ResourceBundle bundle = (ResourceBundle)ReflectionUtil.newInstance(bundleClass);
            Locale locale = OptimizedLocalizationSupport.extractLocale(bundleClass);
            this.bundleNameField.set(bundle, basename);
            this.bundleLocaleField.set(bundle, locale);
            this.prepareBundle(basename, bundle, null, locale, false);
        }
        catch (ReflectionUtil.ReflectionUtilError | ReflectiveOperationException e) {
            throw UserError.abort(e, "Failed to instantiated bundle from class %s, reason %s", bundleClass, e.getCause().getMessage());
        }
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String bundleName, ResourceBundle bundle, Function<String, Optional<Module>> findModule, Locale locale, boolean jdkBundle) {
        bundle.keySet();
        this.resourceBundles.put(new BundleCacheKey(bundleName, locale), bundle);
    }

    private static Locale extractLocale(Class<?> bundleClass) {
        String name = bundleClass.getName();
        int split = name.lastIndexOf(95);
        if (split == -1) {
            return Locale.ROOT;
        }
        return LocaleUtil.parseLocaleFromTag((String)name.substring(split + 1));
    }

    @Override
    public boolean shouldSubstituteLoadLookup(String className) {
        return true;
    }

    private record BundleCacheKey(String bundleName, Locale locale) {
    }

    public record AdaptersByClassKey(Class<? extends LocaleServiceProvider> providerClass, Locale candidateLocale) {
    }
}

