/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.container.Container;
import com.oracle.svm.core.container.OperatingSystem;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_JVM_Util;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventConfiguration;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventWriter;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.util.PlatformTimeUtils;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogTag;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(value=JVM.class)
public final class Target_jdk_jfr_internal_JVM {
    @Alias
    static Object CHUNK_ROTATION_MONITOR;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static volatile boolean nativeOK;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    public static void markChunkFinal() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().markChunkFinal();
    }

    @Substitute
    public static void beginRecording() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().beginRecording();
    }

    @Substitute
    @Uninterruptible(reason="Needed for calling SubstrateJVM.isRecording().")
    public static boolean isRecording() {
        if (!HasJfrSupport.get()) {
            return false;
        }
        return SubstrateJVM.get().isRecording();
    }

    @Substitute
    public static void endRecording() {
        if (!HasJfrSupport.get()) {
            return;
        }
        SubstrateJVM.get().endRecording();
    }

    @Substitute
    public static long counterTime() {
        return JfrTicks.elapsedTicks();
    }

    @Substitute
    public static boolean emitEvent(long eventTypeId, long timestamp, long when) {
        return false;
    }

    @Substitute
    public static List<Class<? extends Event>> getAllEventClasses() {
        return JfrJavaEvents.getAllEventClasses();
    }

    @Substitute
    public static long getUnloadedEventClassCount() {
        return 0L;
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getClassId().")
    public static long getClassId(Class<?> clazz) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getClassId(clazz);
    }

    @Substitute
    public static String getPid() {
        long id = ProcessProperties.getProcessID();
        return String.valueOf(id);
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getStackTraceId().")
    public static long getStackTraceId(int skipCount, long stackFilterId) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getStackTraceId(skipCount);
    }

    @Substitute
    public static long registerStackFilter(String[] classes, String[] methods) {
        throw new UnsupportedOperationException("JFR stack filters are not supported at the moment.");
    }

    @Substitute
    public static void unregisterStackFilter(long stackFilterId) {
    }

    @Substitute
    public static void setMiscellaneous(long eventTypeId, long value) {
    }

    @Substitute
    public static long getThreadId(Thread t) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.getThreadId(t);
    }

    @Substitute
    public static long getTicksFrequency() {
        return JfrTicks.getTicksFrequency();
    }

    @Substitute
    public static long nanosNow() {
        return PlatformTimeUtils.singleton().nanosNow();
    }

    @Substitute
    public static void log(int tagSetId, int level, String message) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().log(tagSetId, level, message);
    }

    @Substitute
    public static void logEvent(int level, String[] lines, boolean system) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().logEvent(level, lines, system);
    }

    @Substitute
    public static void subscribeLogLevel(LogTag lt, int tagSetId) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().subscribeLogLevel(lt, tagSetId);
    }

    @Substitute
    public static synchronized void retransformClasses(Class<?>[] classes) {
    }

    @Substitute
    public static void setEnabled(long eventTypeId, boolean enabled) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setEnabled(eventTypeId, enabled);
    }

    @Substitute
    public static void setFileNotification(long delta) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setFileNotification(delta);
    }

    @Substitute
    public static void setGlobalBufferCount(long count) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setGlobalBufferCount(count);
    }

    @Substitute
    public static void setGlobalBufferSize(long size) throws IllegalArgumentException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setGlobalBufferSize(size);
    }

    @Substitute
    public static void setMemorySize(long size) throws IllegalArgumentException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setMemorySize(size);
    }

    @Substitute
    public static void setMethodSamplingPeriod(long type, long intervalMillis) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setMethodSamplingInterval(type, intervalMillis);
    }

    @Substitute
    public static void setCPURate(double rate) {
    }

    @Substitute
    public static void setCPUPeriod(long periodNanos) {
    }

    @Substitute
    public static void setOutput(String file) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setOutput(file);
    }

    @Substitute
    public static void setForceInstrumentation(boolean force) {
    }

    @Substitute
    public static void setCompressedIntegers(boolean compressed) throws IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setCompressedIntegers(compressed);
    }

    @Substitute
    public static void setStackDepth(int depth) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setStackDepth(depth);
    }

    @Substitute
    public static void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setStackTraceEnabled(eventTypeId, enabled);
    }

    @Substitute
    public static void setThreadBufferSize(long size) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setThreadBufferSize(size);
    }

    @Substitute
    public static boolean setThreshold(long eventTypeId, long ticks) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setThreshold(eventTypeId, ticks);
    }

    @Substitute
    public static void storeMetadataDescriptor(byte[] bytes) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().storeMetadataDescriptor(bytes);
    }

    @Substitute
    public static boolean getAllowedToDoEventRetransforms() {
        return false;
    }

    @Substitute
    private static boolean createJFR(boolean simulateFailure) throws IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().createJFR(simulateFailure);
    }

    @Substitute
    private static boolean destroyJFR() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().destroyJFR();
    }

    @Substitute
    public static boolean isAvailable() {
        return HasJfrSupport.get();
    }

    @Substitute
    public static double getTimeConversionFactor() {
        return 1.0;
    }

    @Substitute
    public static long getTypeId(Class<?> clazz) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return JfrTraceId.getTraceId(clazz);
    }

    @Substitute
    public static Target_jdk_jfr_internal_event_EventWriter getEventWriter() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getEventWriter();
    }

    @Substitute
    public static Target_jdk_jfr_internal_event_EventWriter newEventWriter() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().newEventWriter();
    }

    @Substitute
    public static void flush(Target_jdk_jfr_internal_event_EventWriter writer, int uncommittedSize, int requestedSize) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().flush(writer, uncommittedSize, requestedSize);
    }

    @Substitute
    public static void flush() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().flush();
    }

    @Substitute
    public static long commit(long nextPosition) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().commit(nextPosition);
    }

    @Substitute
    public static void setRepositoryLocation(String dirText) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setRepositoryLocation(dirText);
    }

    @Substitute
    public static void setDumpPath(String dumpPathText) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setDumpPath(dumpPathText);
    }

    @Substitute
    public static String getDumpPath() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getDumpPath();
    }

    @Substitute
    public static void abort(String errorMsg) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().abort(errorMsg);
    }

    @Substitute
    public static boolean addStringConstant(long id, String s) {
        return false;
    }

    @Substitute
    public static void uncaughtException(Thread thread, Throwable t) {
    }

    @Substitute
    public static boolean setCutoff(long eventTypeId, long cutoffTicks) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setCutoff(eventTypeId, cutoffTicks);
    }

    @Substitute
    public static boolean setThrottle(long eventTypeId, long eventSampleSize, long periodMs) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setThrottle(eventTypeId, eventSampleSize, periodMs);
    }

    @Substitute
    public static void emitOldObjectSamples(long cutoff, boolean emitAll, boolean skipBFS) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().emitOldObjectSamples(cutoff, emitAll, skipBFS);
    }

    @Substitute
    public static boolean shouldRotateDisk() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().shouldRotateDisk();
    }

    @Substitute
    public static void include(Thread thread) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        JfrThreadLocal.setExcluded(thread, false);
    }

    @Substitute
    public static void exclude(Thread thread) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        JfrThreadLocal.setExcluded(thread, true);
    }

    @Substitute
    public static boolean isExcluded(Thread thread) {
        if (!HasJfrSupport.get()) {
            return true;
        }
        return JfrThreadLocal.isThreadExcluded(thread);
    }

    @Substitute
    public static boolean isExcluded(Class<? extends Event> eventClass) {
        return !HasJfrSupport.get();
    }

    @Substitute
    public static boolean isInstrumented(Class<? extends Event> eventClass) {
        return HasJfrSupport.get();
    }

    @Substitute
    public static long getChunkStartNanos() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getChunkStartNanos();
    }

    @Substitute
    public static boolean setConfiguration(Class<? extends Event> eventClass, Target_jdk_jfr_internal_event_EventConfiguration configuration) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setConfiguration(eventClass, configuration);
    }

    @Substitute
    public static Object getConfiguration(Class<? extends Event> eventClass) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getConfiguration(eventClass);
    }

    @Substitute
    public static long getTypeId(String name) {
        return -1L;
    }

    @Substitute
    public static boolean isContainerized() {
        return Container.singleton().isContainerized();
    }

    @Substitute
    public static long hostTotalMemory() {
        return OperatingSystem.singleton().getPhysicalMemorySize().rawValue();
    }

    @Substitute
    public static long hostTotalSwapMemory() {
        return -1L;
    }

    @Substitute
    public static boolean isProduct() {
        return true;
    }

    @Substitute
    public static long[] setMethodTraceFilters(String[] classes, String[] methods, String[] annotations, int[] modification) {
        return null;
    }

    @Substitute
    public static long[] drainStaleMethodTracerIds() {
        return null;
    }
}

