/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.pltgot;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.pltgot.GOTHeapSupport;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class GOTAccess {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getGotEntryOffsetFromHeapRegister(int gotEntry) {
        return -(gotEntry + 1) * ConfigurationValues.getTarget().wordSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void writeToGotEntry(int gotEntry, UnsignedWord address) {
        Pointer gotStartAddress = (Pointer)GOTHeapSupport.GOT_START_ADDRESS.get().read();
        Pointer gotEndAddress = gotStartAddress.add(GOTHeapSupport.getPageAlignedGotSize());
        gotEndAddress.writeWord(GOTAccess.getGotEntryOffsetFromHeapRegister(gotEntry), (WordBase)address);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word readFromGotEntry(int gotEntry) {
        Pointer gotStartAddress = (Pointer)GOTHeapSupport.GOT_START_ADDRESS.get().read();
        Pointer gotEndAddress = gotStartAddress.add(GOTHeapSupport.getPageAlignedGotSize());
        return (Word)gotEndAddress.readWord(GOTAccess.getGotEntryOffsetFromHeapRegister(gotEntry));
    }
}

