/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.SignalHandlerSupport;
import com.oracle.svm.core.jdk.Target_jdk_internal_misc_Signal;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.posix.IgnoreSignalsStartupHook;
import com.oracle.svm.core.posix.PosixSubstrateSegfaultHandler;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.CSunMiscSignal;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.thread.NativeSpinLockUtils;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;

@AutomaticallyRegisteredImageSingleton(value={SignalHandlerSupport.class, PosixSignalHandlerSupport.class})
public final class PosixSignalHandlerSupport
implements SignalHandlerSupport {
    static final CGlobalData<CIntPointer> LOCK = CGlobalDataFactory.createBytes(() -> SizeOf.get(CIntPointer.class));
    private Map<String, Integer> signalNameToSignalNum;
    private boolean[] supportedSignals;
    private DispatcherThread dispatcherThread;
    private boolean initialized;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PosixSignalHandlerSupport() {
    }

    @Fold
    public static PosixSignalHandlerSupport singleton() {
        return (PosixSignalHandlerSupport)ImageSingletons.lookup(PosixSignalHandlerSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void setData(Map<String, Integer> signalNameToSignalNum, boolean[] supportedSignals) {
        assert (this.signalNameToSignalNum == null && this.supportedSignals == null);
        this.signalNameToSignalNum = signalNameToSignalNum;
        this.supportedSignals = supportedSignals;
    }

    public int findSignal(String signalName) {
        Integer result = this.signalNameToSignalNum.get(signalName);
        if (result != null) {
            return result;
        }
        return -1;
    }

    @Override
    public long installJavaSignalHandler(int sig, long nativeH) {
        assert (MonitorSupport.singleton().isLockedByCurrentThread(Target_jdk_internal_misc_Signal.class));
        this.ensureInitialized();
        return PosixSignalHandlerSupport.installJavaSignalHandler0(sig, nativeH, SubstrateOptions.EnableSignalHandling.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private static long installJavaSignalHandler0(int sig, long nativeH, boolean isSignalHandlingAllowed) {
        CIntPointer lock = LOCK.get();
        NativeSpinLockUtils.lockNoTransition(lock);
        try {
            PointerBase currentDispatcher;
            Signal.SignalDispatcher newDispatcher = PosixSignalHandlerSupport.handlerToDispatcher(nativeH);
            if (newDispatcher == CSunMiscSignal.signalHandlerFunctionPointer() && !CSunMiscSignal.signalRangeCheck(sig)) {
                long l = -1L;
                return l;
            }
            if ((sig == Signal.SignalEnum.SIGSEGV.getCValue() || sig == Signal.SignalEnum.SIGBUS.getCValue()) && (currentDispatcher = PosixSignalHandlerSupport.getCurrentDispatcher(sig)).equal((ComparableWord)PosixSubstrateSegfaultHandler.SIGNAL_HANDLER.getFunctionPointer())) {
                long l = -1L;
                return l;
            }
            if ((sig == Signal.SignalEnum.SIGHUP.getCValue() || sig == Signal.SignalEnum.SIGINT.getCValue() || sig == Signal.SignalEnum.SIGTERM.getCValue()) && (currentDispatcher = PosixSignalHandlerSupport.getCurrentDispatcher(sig)) == Signal.SIG_IGN()) {
                long l = 1L;
                return l;
            }
            Signal.SignalDispatcher oldDispatcher = PosixSignalHandlerSupport.installNativeSignalHandler0(sig, newDispatcher, Signal.SA_RESTART(), isSignalHandlingAllowed);
            Signal.sigset_tPointer sigset = UnsafeStackValue.get(Signal.sigset_tPointer.class);
            Signal.NoTransitions.sigemptyset(sigset);
            Signal.NoTransitions.sigaddset(sigset, sig);
            Signal.NoTransitions.sigprocmask(Signal.SIG_UNBLOCK(), sigset, (Signal.sigset_tPointer)Word.nullPointer());
            long l = PosixSignalHandlerSupport.dispatcherToHandler(oldDispatcher);
            return l;
        }
        finally {
            NativeSpinLockUtils.unlock(lock);
        }
    }

    private void ensureInitialized() throws IllegalArgumentException {
        assert (MonitorSupport.singleton().isLockedByCurrentThread(Target_jdk_internal_misc_Signal.class));
        if (this.initialized) {
            return;
        }
        int code = CSunMiscSignal.open();
        if (code != 0) {
            if (code == 1) {
                throw new IllegalArgumentException("Java signal handler mechanism is already used by another isolate.");
            }
            int errno = LibC.errno();
            Log.log().string("CSunMiscSignal.open() failed.").string("  errno: ").signed(errno).string("  ").string(Errno.strerror(errno)).newline();
            throw VMError.shouldNotReachHere("CSunMiscSignal.open() failed.");
        }
        this.startDispatcherThread();
        this.initialized = true;
    }

    private void startDispatcherThread() {
        this.dispatcherThread = new DispatcherThread();
        this.dispatcherThread.start();
    }

    @Override
    public void stopDispatcherThread() {
        if (!this.initialized) {
            return;
        }
        this.dispatcherThread.stopped = true;
        int code = CSunMiscSignal.signalSemaphore();
        PosixUtils.checkStatusIs0(code, "CSunMiscSignal.signalSemaphore() failed.");
        try {
            this.dispatcherThread.join();
        }
        catch (InterruptedException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Override
    @Uninterruptible(reason="The isolate teardown is in progress.")
    public void onIsolateTeardown() {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < this.supportedSignals.length; ++i) {
            if (!this.supportedSignals[i]) continue;
            PosixSignalHandlerSupport.resetSignalHandler(i);
        }
        int code = CSunMiscSignal.close();
        PosixUtils.checkStatusIs0(code, "CSunMiscSignal.close() failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private static void resetSignalHandler(int sigNum) {
        CIntPointer lock = LOCK.get();
        NativeSpinLockUtils.lockNoTransition(lock);
        try {
            Signal.SignalDispatcher newDispatcher;
            Signal.SignalDispatcher signalResult;
            PointerBase currentDispatcher = PosixSignalHandlerSupport.getCurrentDispatcher(sigNum);
            if (currentDispatcher == CSunMiscSignal.signalHandlerFunctionPointer() && (signalResult = PosixSignalHandlerSupport.installNativeSignalHandler0(sigNum, newDispatcher = PosixSignalHandlerSupport.getDefaultDispatcher(sigNum), Signal.SA_RESTART(), true)) == Signal.SIG_ERR()) {
                throw VMError.shouldNotReachHere("Failed to reset Java signal handler during isolate teardown.");
            }
        }
        finally {
            NativeSpinLockUtils.unlock(lock);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Signal.SignalDispatcher getDefaultDispatcher(int sigNum) {
        if (sigNum == Signal.SignalEnum.SIGPIPE.getCValue() || sigNum == Signal.SignalEnum.SIGXFSZ.getCValue()) {
            return (Signal.SignalDispatcher)IgnoreSignalsStartupHook.NOOP_SIGNAL_HANDLER.getFunctionPointer();
        }
        return Signal.SIG_DFL();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Signal.SignalDispatcher handlerToDispatcher(long nativeH) {
        if (nativeH == 0L) {
            return Signal.SIG_DFL();
        }
        if (nativeH == 1L) {
            return Signal.SIG_IGN();
        }
        if (nativeH == 2L) {
            return CSunMiscSignal.signalHandlerFunctionPointer();
        }
        if (nativeH == -1L) {
            return Signal.SIG_ERR();
        }
        return (Signal.SignalDispatcher)Word.pointer((long)nativeH);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long dispatcherToHandler(Signal.SignalDispatcher handler) {
        if (handler == Signal.SIG_DFL()) {
            return 0L;
        }
        if (handler == Signal.SIG_IGN()) {
            return 1L;
        }
        if (handler == CSunMiscSignal.signalHandlerFunctionPointer()) {
            return 2L;
        }
        if (handler == Signal.SIG_ERR()) {
            return -1L;
        }
        return handler.rawValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public static Signal.SignalDispatcher installNativeSignalHandler(int signum, Signal.SignalDispatcher handler, int flags, boolean isSignalHandlingAllowed) {
        CIntPointer lock = LOCK.get();
        NativeSpinLockUtils.lockNoTransition(lock);
        try {
            Signal.SignalDispatcher signalDispatcher = PosixSignalHandlerSupport.installNativeSignalHandler0(signum, handler, flags, isSignalHandlingAllowed);
            return signalDispatcher;
        }
        finally {
            NativeSpinLockUtils.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public static void installNativeSignalHandler(Signal.SignalEnum signum, Signal.AdvancedSignalDispatcher handler, int flags, boolean isSignalHandlingAllowed) {
        CIntPointer lock = LOCK.get();
        NativeSpinLockUtils.lockNoTransition(lock);
        try {
            PosixSignalHandlerSupport.installNativeSignalHandler0(signum.getCValue(), handler, flags, isSignalHandlingAllowed);
        }
        finally {
            NativeSpinLockUtils.unlock(lock);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Signal.SignalDispatcher installNativeSignalHandler0(int signum, Signal.SignalDispatcher handler, int flags, boolean isSignalHandlingAllowed) {
        assert (NativeSpinLockUtils.isLocked(LOCK.get()));
        int structSigActionSize = SizeOf.get(Signal.sigaction.class);
        Signal.sigaction act = (Signal.sigaction)UnsafeStackValue.get(structSigActionSize);
        LibC.memset(act, Word.signed((int)0), Word.unsigned((int)structSigActionSize));
        act.sa_flags(flags);
        act.sa_handler(handler);
        Signal.sigaction old = UnsafeStackValue.get(Signal.sigaction.class);
        int result = PosixSignalHandlerSupport.sigaction(signum, act, old, isSignalHandlingAllowed);
        if (result != 0) {
            return Signal.SIG_ERR();
        }
        return old.sa_handler();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void installNativeSignalHandler0(int signum, Signal.AdvancedSignalDispatcher handler, int flags, boolean isSignalHandlingAllowed) {
        assert (NativeSpinLockUtils.isLocked(LOCK.get()));
        int structSigActionSize = SizeOf.get(Signal.sigaction.class);
        Signal.sigaction act = (Signal.sigaction)UnsafeStackValue.get(structSigActionSize);
        LibC.memset(act, Word.signed((int)0), Word.unsigned((int)structSigActionSize));
        act.sa_flags(Signal.SA_SIGINFO() | flags);
        act.sa_sigaction(handler);
        int result = PosixSignalHandlerSupport.sigaction(signum, act, (Signal.sigaction)Word.nullPointer(), isSignalHandlingAllowed);
        PosixUtils.checkStatusIs0(result, "sigaction failed in installSignalHandler().");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static PointerBase getCurrentDispatcher(int sig) {
        assert (NativeSpinLockUtils.isLocked(LOCK.get()));
        Signal.sigaction handler = UnsafeStackValue.get(Signal.sigaction.class);
        Signal.sigaction(sig, (Signal.sigaction)Word.nullPointer(), handler);
        if ((handler.sa_flags() & Signal.SA_SIGINFO()) != Signal.SA_SIGINFO()) {
            return handler.sa_sigaction();
        }
        return handler.sa_handler();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int sigaction(int signum, Signal.sigaction structSigAction, Signal.sigaction old, boolean isSignalHandlingAllowed) {
        assert (NativeSpinLockUtils.isLocked(LOCK.get()));
        VMError.guarantee(isSignalHandlingAllowed, "Trying to install a signal handler while signal handling is disabled.");
        return Signal.sigaction(signum, structSigAction, old);
    }

    private static class DispatcherThread
    extends Thread {
        private volatile boolean stopped;

        DispatcherThread() {
            super(PlatformThreads.singleton().systemGroup, "Signal Dispatcher");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.stopped) {
                int code = CSunMiscSignal.awaitSemaphore();
                PosixUtils.checkStatusIs0(code, "CSunMiscSignal.awaitSemaphore() failed.");
                int sigNum = CSunMiscSignal.checkPendingSignal();
                if (sigNum < 0) continue;
                Target_jdk_internal_misc_Signal.dispatch(sigNum);
            }
        }
    }
}

