/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.Target_java_lang_ThreadLocal_ThreadLocalMap;
import com.oracle.svm.core.thread.Target_java_lang_Thread_Constants;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_java_lang_Thread_ThreadIdentifiers;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_ThreadContainer;
import com.oracle.svm.core.thread.Target_sun_nio_ch_Interruptible;
import com.oracle.svm.core.thread.ThreadData;
import com.oracle.svm.core.thread.ThreadIdRecomputation;
import com.oracle.svm.core.thread.UnacquiredThreadData;
import java.util.Map;
import java.util.Objects;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(value=Thread.class)
public final class Target_java_lang_Thread {
    @Delete
    static StackTraceElement[] EMPTY_STACK_TRACE;
    @Alias
    static int NO_INHERIT_THREAD_LOCALS;
    @Alias
    static Object NEW_THREAD_BINDINGS;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    IsolateThread isolateThread;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile boolean interrupted;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    long parentThreadId;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    public boolean jfrExcluded;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ThreadData.class)
    UnacquiredThreadData threadData;
    @Alias
    ClassLoader contextClassLoader;
    @Alias
    volatile String name;
    @Alias
    Target_java_lang_ThreadLocal_ThreadLocalMap inheritableThreadLocals = null;
    @Alias
    Target_java_lang_Thread_FieldHolder holder;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ThreadIdRecomputation.class)
    public long tid;
    @Alias
    Object interruptLock;
    @Alias
    volatile Target_sun_nio_ch_Interruptible nioBlocker;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Object lockHelper;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Object[] scopedValueCache;
    @Alias
    Object scopedValueBindings;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Thread vthread = null;
    @Alias
    Target_jdk_internal_vm_Continuation cont;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    static volatile Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;

    @Alias
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    native void setPriority(int var1);

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public native boolean isVirtual();

    @Alias
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public native void exit();

    Target_java_lang_Thread(String withName, ThreadGroup withGroup, boolean asDaemon) {
        this.threadData = new ThreadData();
        ThreadGroup nonnullGroup = withGroup != null ? withGroup : PlatformThreads.singleton().mainGroup;
        JavaThreads.initThreadFields(this, nonnullGroup, null, 0L, 5, asDaemon);
        PlatformThreads.setThreadStatus(JavaThreads.fromTarget(this), 5);
        this.tid = Target_java_lang_Thread_ThreadIdentifiers.next();
        this.interruptLock = new Object();
        this.name = withName != null ? withName : "System-" + JavaThreads.nextThreadNum();
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public long getId() {
        return this.tid;
    }

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public native String getName();

    @AnnotateOriginal
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static native ThreadGroup virtualThreadGroup();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AnnotateOriginal
    public native boolean isDaemon();

    @Substitute
    static Thread currentCarrierThread() {
        Thread thread = PlatformThreads.currentThread.get();
        assert (thread != null) : "Thread has not been set yet";
        return thread;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @Substitute
    static Thread currentThread() {
        Thread thread = JavaThreads.getCurrentThreadOrNull();
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((thread != null ? 1 : 0) != 0, (String)"Thread has not been set yet");
        } else assert (thread != null) : "Thread has not been set yet";
        return thread;
    }

    @Substitute
    void setCurrentThread(Thread thread) {
        JavaThreads.setCurrentThread(JavaThreads.fromTarget(this), thread);
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private Target_java_lang_Thread(ThreadGroup g, String name, int characteristics, Runnable target, long stackSize) {
        boolean daemon;
        int priority;
        ThreadGroup group;
        this.interruptLock = new Object();
        this.threadData = new ThreadData();
        this.name = name != null ? name : Target_java_lang_Thread.genThreadName();
        boolean inheritThreadLocals = (characteristics & NO_INHERIT_THREAD_LOCALS) == 0;
        Thread parent = Thread.currentThread();
        ThreadGroup threadGroup = group = g != null ? g : parent.getThreadGroup();
        if (JavaThreads.toTarget(parent) == this) {
            priority = 5;
            daemon = false;
        } else {
            priority = parent.getPriority();
            daemon = parent.isDaemon();
        }
        JavaThreads.initThreadFields(this, group, target, stackSize, priority, daemon);
        PlatformThreads.setThreadStatus(JavaThreads.fromTarget(this), 0);
        JavaThreads.initNewThreadLocalsAndLoader(this, inheritThreadLocals, parent);
        this.tid = JavaThreads.nextThreadID();
        this.scopedValueBindings = NEW_THREAD_BINDINGS;
    }

    @Substitute
    static String genThreadName() {
        int threadNum = JavaThreads.JavaThreadNumberSingleton.singleton().threadInitNumber.incrementAndGet();
        return "Thread-" + threadNum;
    }

    @Substitute
    private Target_java_lang_Thread(String name, int characteristics, boolean bound) {
        if (bound) {
            this.threadData = new ThreadData();
        }
        this.interruptLock = new Object();
        this.name = name != null ? name : "";
        this.tid = Target_java_lang_Thread_ThreadIdentifiers.next();
        boolean inheritThreadLocals = (characteristics & NO_INHERIT_THREAD_LOCALS) == 0;
        JavaThreads.initNewThreadLocalsAndLoader(this, inheritThreadLocals, Thread.currentThread());
        this.scopedValueBindings = NEW_THREAD_BINDINGS;
        if (bound) {
            ThreadGroup g = Target_java_lang_Thread_Constants.VTHREAD_GROUP;
            int pri = 5;
            JavaThreads.initThreadFields(this, g, null, -1L, pri, true);
            PlatformThreads.setThreadStatus(JavaThreads.fromTarget(this), 0);
        }
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private void start0() {
        this.parentThreadId = JavaThreads.getThreadId(Thread.currentThread());
        long stackSize = PlatformThreads.getRequestedStackSize(JavaThreads.fromTarget(this));
        try {
            PlatformThreads.singleton().startThread(JavaThreads.fromTarget(this), stackSize);
        }
        catch (Throwable t) {
            this.parentThreadId = 0L;
            throw t;
        }
        PlatformThreads.compareAndSetThreadStatus(JavaThreads.fromTarget(this), 0, 5);
    }

    @Substitute
    protected void setNativeName(String name) {
        PlatformThreads.singleton().setNativeName(JavaThreads.fromTarget(this), name);
    }

    @Substitute
    private void setPriority0(int priority) {
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    public boolean isInterrupted() {
        return JavaThreads.isInterrupted(JavaThreads.fromTarget(this));
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    void interrupt0() {
        Thread thread = JavaThreads.fromTarget(this);
        PlatformThreads.interruptSleep(thread);
        PlatformThreads.unpark(thread);
        PlatformThreads.wakeUpVMConditionWaiters(thread);
    }

    @Delete
    private static native void registerNatives();

    @Delete
    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    @Delete
    private static native Thread[] getThreads();

    @Substitute
    private boolean alive() {
        return PlatformThreads.isAlive(JavaThreads.fromTarget(this));
    }

    @Substitute
    private static void yield0() {
        PlatformThreads.singleton().yieldCurrent();
    }

    @Substitute
    private static void sleepNanos0(long nanos) throws InterruptedException {
        PlatformThreads.sleep(nanos);
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static boolean holdsLock(Object obj) {
        Objects.requireNonNull(obj);
        return MonitorSupport.singleton().isLockedByCurrentThread(obj);
    }

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private StackTraceElement[] getStackTrace() {
        return JavaThreads.getStackTrace(false, JavaThreads.fromTarget(this));
    }

    @Delete
    private native Object getStackTrace0();

    @Delete
    native StackTraceElement[] asyncGetStackTrace();

    @Substitute
    @Platforms(value={InternalPlatform.NATIVE_ONLY.class})
    private static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        return PlatformThreads.getAllStackTraces();
    }

    @Substitute
    private static Thread[] getAllThreads() {
        return PlatformThreads.getAllThreads();
    }

    @Substitute
    private static void clearInterruptEvent() {
    }

    @Alias
    native void setInterrupt();

    @Alias
    native void clearInterrupt();

    @Substitute
    static Object[] scopedValueCache() {
        return JavaThreads.toTarget((Thread)Target_java_lang_Thread.currentCarrierThread()).scopedValueCache;
    }

    @Substitute
    static void setScopedValueCache(Object[] cache) {
        JavaThreads.toTarget((Thread)Target_java_lang_Thread.currentCarrierThread()).scopedValueCache = cache;
    }

    @Alias
    static native Object scopedValueBindings();

    @Substitute
    @Uninterruptible(reason="Must not call other methods which can trigger a stack overflow.", callerMustBe=true)
    static void setScopedValueBindings(Object bindings) {
        Target_java_lang_Thread thread = SubstrateUtil.cast(PlatformThreads.currentThread.get(), Target_java_lang_Thread.class);
        if (thread.vthread != null) {
            thread = SubstrateUtil.cast(thread.vthread, Target_java_lang_Thread.class);
        }
        thread.scopedValueBindings = bindings;
    }

    @Delete
    static native Object findScopedValueBindings();

    @Alias
    native Thread.State threadState();

    @Substitute
    boolean isTerminated() {
        return (this.holder.threadStatus & 2) != 0;
    }

    @Alias
    native Target_jdk_internal_vm_ThreadContainer threadContainer();

    @Alias
    native long threadId();

    @Delete
    static native long getNextThreadIdOffset();
}

