/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.util.ExitStatus;
import java.util.Optional;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class InterruptImageBuilding
extends RuntimeException {
    static final long serialVersionUID = 754312906378380L;
    private final boolean hasMessage;
    private final ExitStatus exitStatus;

    public InterruptImageBuilding(String message) {
        this(null, message);
    }

    public InterruptImageBuilding(ExitStatus exitStatus, String message) {
        super(message);
        this.hasMessage = true;
        this.exitStatus = exitStatus;
    }

    public InterruptImageBuilding(Throwable cause) {
        super(cause);
        this.hasMessage = cause != null && cause.getMessage() != null;
        this.exitStatus = null;
    }

    public InterruptImageBuilding() {
        this((Throwable)null);
    }

    public Optional<String> getReason() {
        return this.hasMessage ? Optional.of(this.getMessage()) : Optional.empty();
    }

    public Optional<ExitStatus> getExitStatus() {
        return Optional.ofNullable(this.exitStatus);
    }
}

