/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta.aarch64;

import com.oracle.svm.core.CodeSynchronizationOperations;
import com.oracle.svm.core.code.AbstractRuntimeCodeInstaller;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.UserError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton(value={AbstractRuntimeCodeInstaller.RuntimeCodeInstallerPlatformHelper.class})
@Platforms(value={Platform.AARCH64.class})
public class AArch64RuntimeCodeInstallerPlatformHelper
implements AbstractRuntimeCodeInstaller.RuntimeCodeInstallerPlatformHelper {
    AArch64RuntimeCodeInstallerPlatformHelper() {
        RuntimeOptionKey<Boolean> writeableCodeOption = RuntimeCodeCache.Options.WriteableCodeCache;
        if (writeableCodeOption.getValue().booleanValue()) {
            throw UserError.abort("Enabling %s is not supported on this platform.", writeableCodeOption.getName());
        }
    }

    @Override
    public boolean needsInstructionCacheSynchronization() {
        return true;
    }

    @Override
    public void performCodeSynchronization(long codeStart, long codeSize) {
        CodeSynchronizationOperations.clearCache(codeStart, codeSize);
        VMThreads.ActionOnTransitionToJavaSupport.requestAllThreadsSynchronizeCode();
    }
}

