/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.DeadlockWatchdog;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.VMFeature;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.util.TypeResult;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.GraalError;
import org.graalvm.collections.EconomicSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ImageClassLoader {
    public final Platform platform;
    public final NativeImageClassLoaderSupport classLoaderSupport;
    public final DeadlockWatchdog watchdog;
    private final EconomicSet<Class<?>> applicationClasses = EconomicSet.create();
    private final EconomicSet<Class<?>> hostedOnlyClasses = EconomicSet.create();
    private final EconomicSet<Method> systemMethods = EconomicSet.create();
    private final EconomicSet<Field> systemFields = EconomicSet.create();
    private Set<Module> builderModules;
    private static final Field classAnnotationData = ReflectionUtil.lookupField(Class.class, (String)"annotationData");

    ImageClassLoader(Platform platform, NativeImageClassLoaderSupport classLoaderSupport) {
        this.platform = platform;
        this.classLoaderSupport = classLoaderSupport;
        int watchdogInterval = (Integer)SubstrateOptions.DeadlockWatchdogInterval.getValue(classLoaderSupport.getParsedHostedOptions());
        boolean watchdogExitOnTimeout = (Boolean)SubstrateOptions.DeadlockWatchdogExitOnTimeout.getValue(classLoaderSupport.getParsedHostedOptions());
        this.watchdog = new DeadlockWatchdog(watchdogInterval, watchdogExitOnTimeout);
    }

    public void loadAllClasses() throws InterruptedException {
        ForkJoinPool executor = ForkJoinPool.commonPool();
        try {
            this.classLoaderSupport.loadAllClasses(executor, this);
        }
        finally {
            boolean isQuiescence = false;
            while (!isQuiescence) {
                isQuiescence = executor.awaitQuiescence(10L, TimeUnit.MINUTES);
                if (isQuiescence) continue;
                LogUtils.warning((String)"Class loading is slow. Waiting for tasks to complete...");
            }
        }
        this.classLoaderSupport.allClassesLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSystemElements(Class<?> systemClass) {
        Method[] declaredMethods = null;
        try {
            declaredMethods = systemClass.getDeclaredMethods();
        }
        catch (Throwable t) {
            ImageClassLoader.handleClassLoadingError(t);
        }
        if (declaredMethods != null) {
            for (Method systemMethod : declaredMethods) {
                if (!this.isInPlatform(systemMethod)) continue;
                EconomicSet<Method> economicSet = this.systemMethods;
                synchronized (economicSet) {
                    this.systemMethods.add((Object)systemMethod);
                }
            }
        }
        Field[] declaredFields = null;
        try {
            declaredFields = systemClass.getDeclaredFields();
        }
        catch (Throwable t) {
            ImageClassLoader.handleClassLoadingError(t);
        }
        if (declaredFields != null) {
            for (Field systemField : declaredFields) {
                if (!this.isInPlatform(systemField)) continue;
                EconomicSet<Field> economicSet = this.systemFields;
                synchronized (economicSet) {
                    this.systemFields.add((Object)systemField);
                }
            }
        }
    }

    private boolean isInPlatform(AnnotatedElement element) {
        try {
            Platforms platformAnnotation = (Platforms)this.classLoaderSupport.annotationExtractor.extractAnnotation(element, Platforms.class, false);
            return NativeImageGenerator.includedIn(this.platform, platformAnnotation);
        }
        catch (Throwable t) {
            ImageClassLoader.handleClassLoadingError(t);
            return false;
        }
    }

    static void handleClassLoadingError(Throwable t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClass(Class<?> clazz) {
        EconomicSet<Class<?>> platformsAnnotation;
        Object initialAnnotationData;
        try {
            initialAnnotationData = classAnnotationData.get(clazz);
        }
        catch (IllegalAccessException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
        boolean inPlatform = true;
        boolean isHostedOnly = false;
        AnnotatedElement cur = clazz.getPackage();
        if (cur == null) {
            cur = clazz;
        }
        do {
            try {
                platformsAnnotation = (EconomicSet<Class<?>>)this.classLoaderSupport.annotationExtractor.extractAnnotation(cur, Platforms.class, false);
            }
            catch (Throwable t) {
                ImageClassLoader.handleClassLoadingError(t);
                return;
            }
            if (ImageClassLoader.containsHostedOnly((Platforms)platformsAnnotation)) {
                isHostedOnly = true;
            } else if (!NativeImageGenerator.includedIn(this.platform, (Platforms)platformsAnnotation)) {
                inPlatform = false;
            }
            if (cur instanceof Package) {
                cur = clazz;
                continue;
            }
            try {
                cur = ((Class)cur).getEnclosingClass();
            }
            catch (Throwable t) {
                ImageClassLoader.handleClassLoadingError(t);
                cur = null;
            }
        } while (cur != null);
        if (inPlatform) {
            if (isHostedOnly) {
                platformsAnnotation = this.hostedOnlyClasses;
                synchronized (platformsAnnotation) {
                    this.hostedOnlyClasses.add(clazz);
                }
            }
            platformsAnnotation = this.applicationClasses;
            synchronized (platformsAnnotation) {
                this.applicationClasses.add(clazz);
            }
            this.findSystemElements(clazz);
        }
        try {
            assert (classAnnotationData.get(clazz) == initialAnnotationData);
        }
        catch (IllegalAccessException e) {
            throw GraalError.shouldNotReachHere((Throwable)e);
        }
    }

    private static boolean containsHostedOnly(Platforms platformsAnnotation) {
        if (platformsAnnotation != null) {
            for (Class platformClass : platformsAnnotation.value()) {
                if (platformClass != Platform.HOSTED_ONLY.class) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration<URL> findResourcesByName(String resource) throws IOException {
        return this.getClassLoader().getResources(resource);
    }

    @Deprecated
    public Class<?> findClassByName(String name) {
        return this.findClassByName(name, true);
    }

    @Deprecated
    public Class<?> findClassByName(String name, boolean failIfClassMissing) {
        TypeResult<Class<?>> result = this.findClass(name);
        if (failIfClassMissing) {
            return (Class)result.getOrFail();
        }
        return (Class)result.get();
    }

    public Class<?> findClassOrFail(String name) {
        return (Class)this.findClass(name).getOrFail();
    }

    public TypeResult<Class<?>> findClass(String name) {
        return this.findClass(name, true);
    }

    public TypeResult<Class<?>> findClass(String name, boolean allowPrimitives) {
        return ImageClassLoader.findClass(name, allowPrimitives, this.getClassLoader());
    }

    public static TypeResult<Class<?>> findClass(String name, boolean allowPrimitives, ClassLoader loader) {
        try {
            Class<?> primitive;
            if (allowPrimitives && name.indexOf(46) == -1 && (primitive = ImageClassLoader.forPrimitive(name)) != null) {
                return TypeResult.forClass(primitive);
            }
            return TypeResult.forClass(ImageClassLoader.forName(name, false, loader));
        }
        catch (ClassNotFoundException | LinkageError ex) {
            return TypeResult.forException((String)name, (Throwable)ex);
        }
    }

    public static Class<?> forPrimitive(String name) {
        return switch (name) {
            case "boolean" -> Boolean.TYPE;
            case "char" -> Character.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            case "byte" -> Byte.TYPE;
            case "short" -> Short.TYPE;
            case "int" -> Integer.TYPE;
            case "long" -> Long.TYPE;
            case "void" -> Void.TYPE;
            default -> null;
        };
    }

    public Class<?> forName(String className) throws ClassNotFoundException {
        return this.forName(className, false);
    }

    public Class<?> forName(String className, boolean initialize) throws ClassNotFoundException {
        return ImageClassLoader.forName(className, initialize, this.getClassLoader());
    }

    public static Class<?> forName(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(className, initialize, loader);
    }

    public Class<?> forName(String className, Module module) throws ClassNotFoundException {
        if (module == null) {
            return this.forName(className);
        }
        return this.classLoaderSupport.loadClassFromModule(module, className);
    }

    @Deprecated
    public List<String> getClasspath() {
        return this.classpath().stream().map(Path::toString).collect(Collectors.toList());
    }

    public List<Path> classpath() {
        return this.classLoaderSupport.classpath();
    }

    public List<Path> modulepath() {
        return this.classLoaderSupport.modulepath();
    }

    public List<Path> applicationClassPath() {
        return this.classLoaderSupport.applicationClassPath();
    }

    public List<Path> applicationModulePath() {
        return this.classLoaderSupport.applicationModulePath();
    }

    public <T> List<Class<? extends T>> findSubclasses(Class<T> baseClass, boolean includeHostedOnly) {
        ArrayList<Class<? extends T>> result = new ArrayList<Class<? extends T>>();
        ImageClassLoader.addSubclasses(this.applicationClasses, baseClass, result);
        if (includeHostedOnly) {
            ImageClassLoader.addSubclasses(this.hostedOnlyClasses, baseClass, result);
        }
        return result;
    }

    private static <T> void addSubclasses(EconomicSet<Class<?>> classes, Class<T> baseClass, ArrayList<Class<? extends T>> result) {
        for (Class systemClass : classes) {
            if (!baseClass.isAssignableFrom(systemClass)) continue;
            result.add(systemClass.asSubclass(baseClass));
        }
    }

    public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotationClass, boolean includeHostedOnly) {
        ArrayList result = new ArrayList();
        this.addAnnotatedClasses(this.applicationClasses, annotationClass, result);
        if (includeHostedOnly) {
            this.addAnnotatedClasses(this.hostedOnlyClasses, annotationClass, result);
        }
        return result;
    }

    private void addAnnotatedClasses(EconomicSet<Class<?>> classes, Class<? extends Annotation> annotationClass, ArrayList<Class<?>> result) {
        for (Class systemClass : classes) {
            if (!this.classLoaderSupport.annotationExtractor.hasAnnotation((AnnotatedElement)systemClass, annotationClass)) continue;
            result.add(systemClass);
        }
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.systemMethods) {
            if (!this.classLoaderSupport.annotationExtractor.hasAnnotation((AnnotatedElement)method, annotationClass)) continue;
            result.add(method);
        }
        return result;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation>[] annotationClasses) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.systemMethods) {
            boolean match = true;
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (this.classLoaderSupport.annotationExtractor.hasAnnotation((AnnotatedElement)method, annotationClass)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            result.add(method);
        }
        return result;
    }

    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotationClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : this.systemFields) {
            if (!this.classLoaderSupport.annotationExtractor.hasAnnotation((AnnotatedElement)field, annotationClass)) continue;
            result.add(field);
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderSupport.getClassLoader();
    }

    public static Optional<String> getMainClassFromModule(Object module) {
        return NativeImageClassLoaderSupport.getMainClassFromModule(module);
    }

    public Optional<Module> findModule(String moduleName) {
        return this.classLoaderSupport.findModule(moduleName);
    }

    public String getMainClassNotFoundErrorMessage(String className) {
        List<Path> classPath = this.applicationClassPath();
        String classPathString = classPath.isEmpty() ? "empty classpath" : "classpath: '%s'".formatted(ImageClassLoader.pathsToString(classPath));
        List<Path> modulePath = this.applicationModulePath();
        String modulePathString = modulePath.isEmpty() ? "empty modulepath" : "modulepath: '%s'".formatted(ImageClassLoader.pathsToString(modulePath));
        return String.format("Main entry point class '%s' neither found on %n%s nor%n%s.", className, classPathString, modulePathString);
    }

    private static String pathsToString(List<Path> paths) {
        return paths.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(File.pathSeparator));
    }

    public EconomicSet<String> classes(URI container) {
        return this.classLoaderSupport.classes(container);
    }

    public EconomicSet<String> packages(URI container) {
        return this.classLoaderSupport.packages(container);
    }

    public boolean noEntryForURI(EconomicSet<String> set) {
        return this.classLoaderSupport.noEntryForURI(set);
    }

    public Set<Module> getBuilderModules() {
        assert (this.builderModules != null) : "Builder modules not yet initialized.";
        return this.builderModules;
    }

    public void initBuilderModules() {
        VMError.guarantee(BuildPhaseProvider.isFeatureRegistrationFinished() && ImageSingletons.contains(VMFeature.class), "Querying builder modules is only possible after feature registration is finished.");
        Module m0 = ((VMFeature)ImageSingletons.lookup(VMFeature.class)).getClass().getModule();
        Module m1 = SVMHost.class.getModule();
        this.builderModules = m0.equals(m1) ? Set.of(m0) : Set.of(m0, m1);
    }
}

