/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.riscv64.RISCV64CPUFeatureAccess;
import com.oracle.svm.core.riscv64.RISCV64LibCHelper;
import com.oracle.svm.hosted.CPUFeatureAccessFeatureBase;
import com.oracle.svm.hosted.FeatureImpl;
import java.util.EnumSet;
import jdk.vm.ci.riscv64.RISCV64;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.RISCV64.class})
class RISCV64CPUFeatureAccessFeature
extends CPUFeatureAccessFeatureBase
implements InternalFeature {
    RISCV64CPUFeatureAccessFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        SubstrateTargetDescription targetDescription = (SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class));
        RISCV64 arch = (RISCV64)targetDescription.arch;
        EnumSet buildtimeCPUFeatures = arch.getFeatures();
        this.initializeCPUFeatureAccessData((Enum<T>[])RISCV64.CPUFeature.values(), buildtimeCPUFeatures, RISCV64LibCHelper.CPUFeatures.class, (FeatureImpl.BeforeAnalysisAccessImpl)arg);
    }

    @Override
    protected RISCV64CPUFeatureAccess createCPUFeatureAccessSingleton(EnumSet<?> buildtimeCPUFeatures, int[] offsets, byte[] errorMessageBytes, byte[] buildtimeFeatureMaskBytes) {
        return new RISCV64CPUFeatureAccess(buildtimeCPUFeatures, offsets, errorMessageBytes, buildtimeFeatureMaskBytes);
    }
}

