/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.RegistryAdapter;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import com.oracle.svm.util.TypeResult;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.List;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeJNIAccessSupport;
import org.graalvm.nativeimage.impl.RuntimeProxyCreationSupport;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class ReflectionRegistryAdapter
extends RegistryAdapter {
    private final RuntimeReflectionSupport reflectionSupport;
    private final RuntimeProxyCreationSupport proxyRegistry;
    private final RuntimeSerializationSupport<ConfigurationCondition> serializationSupport;
    private final RuntimeJNIAccessSupport jniSupport;

    ReflectionRegistryAdapter(RuntimeReflectionSupport reflectionSupport, RuntimeProxyCreationSupport proxyRegistry, RuntimeSerializationSupport<ConfigurationCondition> serializationSupport, RuntimeJNIAccessSupport jniSupport, ImageClassLoader classLoader) {
        super((ReflectionRegistry)reflectionSupport, classLoader);
        this.reflectionSupport = reflectionSupport;
        this.proxyRegistry = proxyRegistry;
        this.serializationSupport = serializationSupport;
        this.jniSupport = jniSupport;
    }

    @Override
    public void registerType(ConfigurationCondition condition, Class<?> type) {
        super.registerType(condition, type);
        if (Proxy.isProxyClass(type)) {
            this.proxyRegistry.addProxyClass(condition, (Class[])type.getInterfaces());
        }
    }

    @Override
    public TypeResult<Class<?>> resolveType(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives, boolean jniAccessible) {
        TypeResult<Class<?>> result = super.resolveType(condition, typeDescriptor, allowPrimitives, jniAccessible);
        this.registerTypeResolutionErrors(result, condition, typeDescriptor, jniAccessible);
        return result;
    }

    @Override
    public TypeResult<List<Class<?>>> resolveTypes(ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean allowPrimitives, boolean jniAccessible) {
        TypeResult<List<Class<?>>> result = super.resolveTypes(condition, typeDescriptor, allowPrimitives, jniAccessible);
        this.registerTypeResolutionErrors(result, condition, typeDescriptor, jniAccessible);
        return result;
    }

    private void registerTypeResolutionErrors(TypeResult<?> result, ConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor, boolean jniAccessible) {
        if (!result.isPresent() && typeDescriptor instanceof NamedConfigurationTypeDescriptor) {
            NamedConfigurationTypeDescriptor namedDescriptor = (NamedConfigurationTypeDescriptor)typeDescriptor;
            Throwable classLookupException = result.getException();
            if (classLookupException instanceof LinkageError) {
                String reflectionName = ClassNameSupport.typeNameToReflectionName((String)namedDescriptor.name());
                this.reflectionSupport.registerClassLookupException(condition, reflectionName, classLookupException);
            } else if (MissingRegistrationUtils.throwMissingRegistrationErrors() && jniAccessible & classLookupException instanceof ClassNotFoundException) {
                String jniName = ClassNameSupport.typeNameToJNIName((String)namedDescriptor.name());
                this.jniSupport.registerClassLookup(condition, jniName);
            }
        }
    }

    @Override
    public void registerPublicClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllClassesQuery(condition, type);
    }

    @Override
    public void registerDeclaredClasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredClassesQuery(condition, type);
    }

    @Override
    public void registerRecordComponents(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllRecordComponentsQuery(condition, type);
    }

    @Override
    public void registerPermittedSubclasses(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllPermittedSubclassesQuery(condition, type);
    }

    @Override
    public void registerNestMembers(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllNestMembersQuery(condition, type);
    }

    @Override
    public void registerSigners(ConfigurationCondition condition, Class<?> type) {
        this.reflectionSupport.registerAllSignersQuery(condition, type);
    }

    @Override
    public void registerPublicFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        RuntimeReflectionSupport runtimeReflectionSupport;
        if (queriedOnly && (runtimeReflectionSupport = this.reflectionSupport) instanceof ReflectionDataBuilder) {
            ReflectionDataBuilder reflectionDataBuilder = (ReflectionDataBuilder)runtimeReflectionSupport;
            reflectionDataBuilder.registerAllFieldsQuery(condition, true, type);
        } else if (!queriedOnly) {
            this.reflectionSupport.registerAllFields(condition, type);
            if (jniAccessible) {
                this.jniSupport.register(condition, false, type.getFields());
            }
        }
    }

    @Override
    public void registerDeclaredFields(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        RuntimeReflectionSupport runtimeReflectionSupport;
        if (queriedOnly && (runtimeReflectionSupport = this.reflectionSupport) instanceof ReflectionDataBuilder) {
            ReflectionDataBuilder reflectionDataBuilder = (ReflectionDataBuilder)runtimeReflectionSupport;
            reflectionDataBuilder.registerAllDeclaredFieldsQuery(condition, true, type);
        } else if (!queriedOnly) {
            this.reflectionSupport.registerAllDeclaredFields(condition, type);
            if (jniAccessible) {
                this.jniSupport.register(condition, false, type.getDeclaredFields());
            }
        }
    }

    @Override
    public void registerPublicMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllMethodsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getMethods());
        }
    }

    @Override
    public void registerDeclaredMethods(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredMethodsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getDeclaredMethods());
        }
    }

    @Override
    public void registerPublicConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllConstructorsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getConstructors());
        }
    }

    @Override
    public void registerDeclaredConstructors(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Class<?> type) {
        this.reflectionSupport.registerAllDeclaredConstructorsQuery(condition, queriedOnly, type);
        if (!queriedOnly && jniAccessible) {
            this.jniSupport.register(condition, false, (Executable[])type.getDeclaredConstructors());
        }
    }

    @Override
    public void registerAsSerializable(ConfigurationCondition condition, Class<?> clazz) {
        this.serializationSupport.register((Object)condition, clazz);
    }

    @Override
    public void registerAsJniAccessed(ConfigurationCondition condition, Class<?> clazz) {
        this.jniSupport.register(condition, new Class[]{clazz});
    }

    @Override
    protected void registerField(ConfigurationCondition condition, boolean allowWrite, boolean jniAccessible, Field field) {
        super.registerField(condition, allowWrite, jniAccessible, field);
        if (jniAccessible) {
            this.jniSupport.register(condition, allowWrite, new Field[]{field});
        }
    }

    @Override
    protected void registerFieldNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, String fieldName) {
        super.registerFieldNegativeQuery(condition, jniAccessible, type, fieldName);
        if (jniAccessible) {
            this.jniSupport.registerFieldLookup(condition, type, fieldName);
        }
    }

    @Override
    protected void registerExecutable(ConfigurationCondition condition, boolean queriedOnly, boolean jniAccessible, Executable ... executable) {
        super.registerExecutable(condition, queriedOnly, jniAccessible, executable);
        if (jniAccessible) {
            this.jniSupport.register(condition, queriedOnly, executable);
        }
    }

    @Override
    protected void registerMethodNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, String methodName, List<Class<?>> methodParameterTypes) {
        super.registerMethodNegativeQuery(condition, jniAccessible, type, methodName, methodParameterTypes);
        if (jniAccessible) {
            this.jniSupport.registerMethodLookup(condition, type, methodName, (Class[])ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes));
        }
    }

    @Override
    protected void registerConstructorNegativeQuery(ConfigurationCondition condition, boolean jniAccessible, Class<?> type, List<Class<?>> constructorParameterTypes) {
        super.registerConstructorNegativeQuery(condition, jniAccessible, type, constructorParameterTypes);
        if (jniAccessible) {
            this.jniSupport.registerConstructorLookup(condition, type, (Class[])ReflectionRegistryAdapter.getParameterTypes(constructorParameterTypes));
        }
    }
}

