/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.code.FactoryMethodMarker;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;

public class ImplicitAssertionsPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)graph.method().getDeclaringClass(), FactoryMethodMarker.class)) {
            return;
        }
        HashMap<ResolvedJavaMethod, BytecodeExceptionNode.BytecodeExceptionKind> constructorReplacements = new HashMap<ResolvedJavaMethod, BytecodeExceptionNode.BytecodeExceptionKind>();
        constructorReplacements.put(context.getMetaAccess().lookupJavaMethod((Executable)ReflectionUtil.lookupConstructor(AssertionError.class, (Class[])new Class[0])), BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY);
        constructorReplacements.put(context.getMetaAccess().lookupJavaMethod((Executable)ReflectionUtil.lookupConstructor(AssertionError.class, (Class[])new Class[]{Object.class})), BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT);
        for (Invoke invoke : graph.getInvokes()) {
            ImplicitAssertionsPhase.tryOptimize(graph, invoke, context, constructorReplacements);
        }
    }

    private static void tryOptimize(StructuredGraph graph, Invoke constructorInvoke, CoreProviders context, HashMap<ResolvedJavaMethod, BytecodeExceptionNode.BytecodeExceptionKind> constructorReplacements) {
        BytecodeExceptionNode.BytecodeExceptionKind bytecodeExceptionKind = constructorReplacements.get(constructorInvoke.getTargetMethod());
        if (bytecodeExceptionKind == null) {
            return;
        }
        if (!(constructorInvoke.callTarget() instanceof MethodCallTargetNode)) {
            return;
        }
        MethodCallTargetNode callTargetNode = (MethodCallTargetNode)constructorInvoke.callTarget();
        if (!(callTargetNode.receiver() instanceof NewInstanceNode)) {
            return;
        }
        NewInstanceNode exceptionAllocation = (NewInstanceNode)callTargetNode.receiver();
        HashSet<FrameState> usagesToDelete = new HashSet<FrameState>();
        if (!ImplicitAssertionsPhase.hasSimpleControlFlow(constructorInvoke.predecessor(), (FixedNode)exceptionAllocation, usagesToDelete)) {
            return;
        }
        for (Node exceptionUsage : exceptionAllocation.usages()) {
            if (exceptionUsage == callTargetNode || exceptionUsage == constructorInvoke.stateAfter() || usagesToDelete.contains(exceptionUsage)) continue;
            if (exceptionUsage instanceof UnwindNode) {
                if (ImplicitAssertionsPhase.hasSimpleControlFlow(exceptionUsage, constructorInvoke.asFixedNode(), null)) continue;
                return;
            }
            if (exceptionUsage instanceof PhiNode) {
                PhiNode phi = (PhiNode)exceptionUsage;
                for (int i = 0; i < phi.valueCount(); ++i) {
                    if (phi.valueAt(i) != exceptionAllocation || ImplicitAssertionsPhase.hasSimpleControlFlow((Node)phi.merge().phiPredecessorAt(i), constructorInvoke.asFixedNode(), null)) continue;
                    return;
                }
                continue;
            }
            if (exceptionUsage instanceof FrameState && exceptionUsage.usages().count() == 1 && exceptionUsage.usages().first() instanceof FullInfopointNode) {
                usagesToDelete.add((FrameState)exceptionUsage);
                continue;
            }
            return;
        }
        for (FrameState usageToDelete : usagesToDelete) {
            usageToDelete.replaceAllInputs((Node)exceptionAllocation, null);
        }
        ArrayList args = new ArrayList(callTargetNode.arguments());
        args.remove(0);
        BytecodeExceptionNode replacement = (BytecodeExceptionNode)graph.add((Node)new BytecodeExceptionNode(context.getMetaAccess(), bytecodeExceptionKind, args.toArray(ValueNode.EMPTY_ARRAY)));
        replacement.setStateAfter(constructorInvoke.stateAfter());
        InvokeNode invokeNode = constructorInvoke instanceof InvokeWithExceptionNode ? ((InvokeWithExceptionNode)constructorInvoke).replaceWithNonThrowing() : (InvokeNode)constructorInvoke;
        replacement.setNodeSourcePosition(invokeNode.getNodeSourcePosition());
        graph.replaceFixedWithFixed((FixedWithNextNode)invokeNode, (FixedWithNextNode)replacement);
        graph.replaceFixedWithFloating((FixedWithNextNode)exceptionAllocation, (ValueNode)replacement);
    }

    private static boolean hasSimpleControlFlow(Node sink, FixedNode source, Set<FrameState> collectedFrameStates) {
        Node cur = sink;
        while (cur != null) {
            if (cur == source) {
                return true;
            }
            if (collectedFrameStates != null && cur instanceof StateSplit) {
                collectedFrameStates.add(((StateSplit)cur).stateAfter());
            }
            cur = cur.predecessor();
        }
        return false;
    }
}

