/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.aarch64.SubstrateAArch64MacroAssembler;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.pltgot.GOTAccess;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.PLTSectionSupport;
import com.oracle.svm.hosted.pltgot.PLTStubGenerator;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class AArch64PLTStubGenerator
implements PLTStubGenerator {
    private int resolverAddressLoadOffset = -1;

    @Override
    public byte[] generatePLT(SharedMethod[] got, SubstrateBackend substrateBackend) {
        SubstrateAArch64MacroAssembler masm = new SubstrateAArch64MacroAssembler(ConfigurationValues.getTarget());
        Label pltStart = new Label();
        masm.bind(pltStart);
        try (AArch64MacroAssembler.ScratchRegister scratchRegister1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister scratchRegister2 = masm.getScratchRegister();){
            Register resolverJmpRegister = scratchRegister1.getRegister();
            Register gotEntryPassingRegister = scratchRegister2.getRegister();
            this.generateResolverCallStub(masm, gotEntryPassingRegister, resolverJmpRegister);
            PLTSectionSupport support = HostedPLTGOTConfiguration.singleton().getPLTSectionSupport();
            for (int gotEntryNo = 0; gotEntryNo < got.length; ++gotEntryNo) {
                HostedMethod method = (HostedMethod)got[gotEntryNo];
                int pltStubStart = masm.position();
                support.recordMethodPLTStubStart(method, pltStubStart);
                int gotEntryOffset = GOTAccess.getGotEntryOffsetFromHeapRegister(gotEntryNo);
                Register heapReg = ReservedRegisters.singleton().getHeapBaseRegister();
                AArch64Address addr = masm.makeAddress(64, heapReg, gotEntryOffset, gotEntryPassingRegister);
                masm.maybeEmitIndirectTargetMarker();
                masm.ldr(64, gotEntryPassingRegister, addr);
                masm.jmp(gotEntryPassingRegister);
                support.recordMethodPLTStubResolverOffset(method, masm.position() - pltStubStart);
                masm.maybeEmitIndirectTargetMarker();
                masm.mov(gotEntryPassingRegister, gotEntryNo);
                masm.jmp(pltStart);
            }
        }
        return masm.close(true);
    }

    @Override
    public void markResolverMethodPatch(ObjectFile.ProgbitsSectionImpl pltBuffer, ResolvedJavaMethod resolverMethod) {
        pltBuffer.markRelocationSite(this.resolverAddressLoadOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, NativeImage.localSymbolNameForMethod(resolverMethod), 0L);
        pltBuffer.markRelocationSite(this.resolverAddressLoadOffset + 4, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADD_ABS_LO12_NC, NativeImage.localSymbolNameForMethod(resolverMethod), 0L);
    }

    public void generateResolverCallStub(AArch64MacroAssembler masm, Register gotEntryPassingRegister, Register jmpTarget) {
        masm.setCodePatchingAnnotationConsumer(this::recordResolverCallForPatching);
        Register scratch = jmpTarget;
        masm.ldr(64, scratch, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.sp, (int)0));
        masm.and(64, scratch, scratch, -72057594037927936L);
        masm.orr(64, gotEntryPassingRegister, gotEntryPassingRegister, scratch);
        masm.adrpAdd(jmpTarget);
        masm.str(64, gotEntryPassingRegister, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)AArch64.sp, (int)0));
        masm.jmp(jmpTarget);
    }

    private void recordResolverCallForPatching(Assembler.CodeAnnotation a) {
        if (this.resolverAddressLoadOffset != -1) {
            return;
        }
        assert (a instanceof AArch64MacroAssembler.AdrpAddMacroInstruction);
        AArch64MacroAssembler.AdrpAddMacroInstruction annotation = (AArch64MacroAssembler.AdrpAddMacroInstruction)a;
        this.resolverAddressLoadOffset = annotation.instructionPosition;
    }
}

