/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class DeletedMethod
extends CustomSubstitutionMethod {
    public static final String NATIVE_MESSAGE = String.format("Native method. If you intend to use the Java Native Interface (JNI), specify %1$s+JNI and see also %1$sJNIConfigurationFiles=<path> (use %1$s+PrintFlags for details)", "-H:");
    private final String message;
    private final AnnotationValue[] injectedAnnotations;
    public static final Method reportErrorMethod = ReflectionUtil.lookupMethod(VMError.class, (String)"unsupportedFeature", (Class[])new Class[]{String.class});

    public DeletedMethod(ResolvedJavaMethod original, Delete deleteAnnotation) {
        super(original);
        this.message = deleteAnnotation.value();
        this.injectedAnnotations = SubstrateAnnotationExtractor.prepareInjectedAnnotations(new Annotation[]{deleteAnnotation});
    }

    @Override
    public AnnotationValue[] getInjectedAnnotations() {
        return this.injectedAnnotations;
    }

    @Override
    public int getModifiers() {
        return this.original.getModifiers() & 0xFFFFFFDF;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        return DeletedMethod.buildGraph(debug, method, providers, this.message);
    }

    public static StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, String message) {
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        kit.getGraph().start().setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)kit.getGraph().start()));
        String msg = AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)method, message, false);
        ConstantNode msgNode = ConstantNode.forConstant((JavaConstant)kit.getConstantReflection().forString(msg), (MetaAccessProvider)kit.getMetaAccess(), (StructuredGraph)kit.getGraph());
        InvokeWithExceptionNode exceptionNode = kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)kit.getMetaAccess().lookupJavaMethod((Executable)reportErrorMethod), CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[]{msgNode});
        kit.append((Node)new UnwindNode((ValueNode)exceptionNode));
        return kit.finalizeGraph();
    }
}

