/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.fieldvaluetransformer.ObjectToConstantFieldValueTransformer;
import com.oracle.svm.core.util.UserError;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

public class FieldValueTransformation {
    protected final FieldValueTransformer fieldValueTransformer;
    protected final Class<?> transformedValueAllowedType;
    private final EconomicMap<JavaConstant, JavaConstant> valueCache = EconomicMap.create();
    private final ReentrantReadWriteLock valueCacheLock = new ReentrantReadWriteLock();

    public FieldValueTransformation(Class<?> transformedValueAllowedType, FieldValueTransformer fieldValueTransformer) {
        this.fieldValueTransformer = fieldValueTransformer;
        this.transformedValueAllowedType = transformedValueAllowedType;
    }

    public FieldValueTransformer getFieldValueTransformer() {
        return this.fieldValueTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaConstant readValue(AnalysisField field, JavaConstant receiver) {
        ReentrantReadWriteLock.ReadLock readLock = this.valueCacheLock.readLock();
        try {
            readLock.lock();
            JavaConstant result = this.getCached(receiver);
            if (result != null) {
                JavaConstant javaConstant = result;
                return javaConstant;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.valueCacheLock.writeLock();
        try {
            writeLock.lock();
            JavaConstant result = this.getCached(receiver);
            if (result != null) {
                JavaConstant javaConstant = result;
                return javaConstant;
            }
            result = this.computeValue(field, receiver);
            this.putCached(receiver, result);
            JavaConstant javaConstant = result;
            return javaConstant;
        }
        finally {
            writeLock.unlock();
        }
    }

    private JavaConstant computeValue(AnalysisField field, JavaConstant receiver) {
        JavaConstant result;
        Object receiverValue = receiver == null ? null : GraalAccess.getOriginalSnippetReflection().asObject(Object.class, receiver);
        Object originalValue = this.fetchOriginalValue(field, receiver);
        Function<Object, JavaConstant> constantConverter = obj -> {
            this.checkValue(obj, field);
            return GraalAccess.getOriginalSnippetReflection().forBoxed(field.getJavaKind(), obj);
        };
        FieldValueTransformer fieldValueTransformer = this.fieldValueTransformer;
        if (fieldValueTransformer instanceof ObjectToConstantFieldValueTransformer) {
            ObjectToConstantFieldValueTransformer objectToConstantFieldValueTransformer = (ObjectToConstantFieldValueTransformer)fieldValueTransformer;
            result = objectToConstantFieldValueTransformer.transformToConstant((ResolvedJavaField)field, receiverValue, originalValue, constantConverter);
        } else {
            Object newValue = this.fieldValueTransformer.transform(receiverValue, originalValue);
            result = constantConverter.apply(newValue);
        }
        assert (result.getJavaKind() == field.getJavaKind());
        return result;
    }

    private void checkValue(Object newValue, AnalysisField field) {
        Class<?> actualType;
        boolean primitive = this.transformedValueAllowedType.isPrimitive();
        if (newValue == null) {
            if (primitive) {
                throw UserError.abort("Field value transformer returned null for primitive %s", field.format("%H.%n"));
            }
            return;
        }
        Class<?> clazz = actualType = primitive ? SubstrateUtil.toUnboxedClass(newValue.getClass()) : newValue.getClass();
        if (!this.transformedValueAllowedType.isAssignableFrom(actualType)) {
            throw UserError.abort("Field value transformer returned value of type `%s` that is not assignable to declared type `%s` of %s", actualType.getTypeName(), this.transformedValueAllowedType.getTypeName(), field.format("%H.%n"));
        }
    }

    protected Object fetchOriginalValue(AnalysisField aField, JavaConstant receiver) {
        ResolvedJavaField oField = OriginalFieldProvider.getOriginalField((ResolvedJavaField)aField);
        if (oField == null) {
            return null;
        }
        JavaConstant originalValueConstant = GraalAccess.getOriginalProviders().getConstantReflection().readFieldValue(oField, receiver);
        if (originalValueConstant == null) {
            return null;
        }
        if (originalValueConstant.getJavaKind().isPrimitive()) {
            return originalValueConstant.asBoxedPrimitive();
        }
        return GraalAccess.getOriginalSnippetReflection().asObject(Object.class, originalValueConstant);
    }

    private void putCached(JavaConstant receiver, JavaConstant result) {
        JavaConstant key = receiver == null ? JavaConstant.NULL_POINTER : receiver;
        this.valueCache.put((Object)key, (Object)result);
    }

    private JavaConstant getCached(JavaConstant receiver) {
        JavaConstant key = receiver == null ? JavaConstant.NULL_POINTER : receiver;
        return (JavaConstant)this.valueCache.get((Object)key);
    }
}

