/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.thread.ThreadListenerSupport;
import com.oracle.svm.core.thread.VMOperationControl;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ThreadStartDeathSupport
implements ThreadListener {
    private final Thread[] debuggerThreads = new Thread[2];
    private static final int DEBUGGER_THREAD_INDEX_SERVER = 0;
    private static final int DEBUGGER_THREAD_INDEX_OBJECTS_QUEUE = 1;
    private volatile boolean start;
    private volatile boolean death;
    private volatile Listener listener;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    ThreadStartDeathSupport() {
        ThreadListenerSupport.get().register(this);
        RuntimeSupport.getRuntimeSupport().addShutdownHook(new RuntimeSupport.Hook(){

            @Override
            public void execute(boolean isFirstIsolate) {
                Listener l = ThreadStartDeathSupport.this.listener;
                if (l != null) {
                    l.vmDied();
                }
            }
        });
    }

    @Fold
    public static ThreadStartDeathSupport get() {
        return (ThreadStartDeathSupport)ImageSingletons.lookup(ThreadStartDeathSupport.class);
    }

    void setDebuggerThreadServer(Thread serverThread) {
        this.debuggerThreads[0] = serverThread;
    }

    void setDebuggerThreadObjectQueue(Thread serverThread) {
        this.debuggerThreads[1] = serverThread;
    }

    public Thread filterAppThread(IsolateThread isolateThread) {
        if (VMOperationControl.isDedicatedVMOperationThread(isolateThread)) {
            return null;
        }
        Thread thread = PlatformThreads.fromVMThread(isolateThread);
        if (thread == null) {
            return null;
        }
        for (Thread t : this.debuggerThreads) {
            if (t != thread) continue;
            return null;
        }
        if (thread.getName().startsWith("System-")) {
            return null;
        }
        return thread;
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    void setListeningOn(boolean startOrDeath, boolean enable) {
        if (startOrDeath) {
            this.start = enable;
        } else {
            this.death = enable;
        }
    }

    @Override
    public void beforeThreadRun() {
        Listener l = this.listener;
        if (l != null && this.start) {
            l.threadStarted();
        }
    }

    @Override
    @Uninterruptible(reason="Only uninterruptible because we need to prevent stack overflow errors.")
    public void afterThreadRun() {
        Listener l = this.listener;
        if (l != null && this.death) {
            l.threadDied();
        }
    }

    static interface Listener {
        public void threadStarted();

        public void threadDied();

        public void vmDied();
    }
}

