/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConditionalConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.LegacyReflectionConfigurationParser;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.configure.ReflectionMetadataParser;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.TypeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;

public abstract class ReflectionConfigurationParser<C, T>
extends ConditionalConfigurationParser {
    private static final String CONSTRUCTOR_NAME = "<init>";
    protected final ConfigurationConditionResolver<C> conditionResolver;
    protected final ReflectionConfigurationParserDelegate<C, T> delegate;

    public ReflectionConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, ReflectionConfigurationParserDelegate<C, T> delegate, EnumSet<ConfigurationParserOption> parserOptions) {
        super(parserOptions);
        this.conditionResolver = conditionResolver;
        this.delegate = delegate;
    }

    @Override
    protected EnumSet<ConfigurationParserOption> supportedOptions() {
        EnumSet<ConfigurationParserOption> base = super.supportedOptions();
        base.add(ConfigurationParserOption.PRINT_MISSING_ELEMENTS);
        base.add(ConfigurationParserOption.JNI_PARSER);
        return base;
    }

    public static <C, T> ReflectionConfigurationParser<C, T> create(boolean combinedFileSchema, ConfigurationConditionResolver<C> conditionResolver, ReflectionConfigurationParserDelegate<C, T> delegate, EnumSet<ConfigurationParserOption> parserOptions) {
        if (combinedFileSchema) {
            return new ReflectionMetadataParser<C, T>(conditionResolver, delegate, parserOptions);
        }
        return new LegacyReflectionConfigurationParser<C, T>(conditionResolver, delegate, parserOptions);
    }

    protected void parseClassArray(List<Object> classes) {
        for (Object clazz : classes) {
            this.parseClass(ReflectionConfigurationParser.asMap(clazz, "second level of document must be class descriptor objects"));
        }
    }

    protected abstract void parseClass(EconomicMap<String, Object> var1);

    protected void registerIfNotDefault(EconomicMap<String, Object> data, boolean defaultValue, T clazz, String propertyName, Runnable register) {
        if (data.containsKey((Object)propertyName) ? ReflectionConfigurationParser.asBoolean(data.get((Object)propertyName), propertyName) : defaultValue) {
            try {
                register.run();
            }
            catch (LinkageError e) {
                this.handleMissingElement("Could not register " + this.delegate.getTypeName(clazz) + ": " + propertyName + " for reflection.", e);
            }
        }
    }

    protected void parseFields(C condition, List<Object> fields, T clazz, boolean jniAccessible) {
        for (Object field : fields) {
            this.parseField(condition, ReflectionConfigurationParser.asMap(field, "Elements of 'fields' array must be field descriptor objects"), clazz, jniAccessible);
        }
    }

    private void parseField(C condition, EconomicMap<String, Object> data, T clazz, boolean jniAccessible) {
        this.checkAttributes(data, "reflection field descriptor object", Collections.singleton("name"), Arrays.asList("allowWrite", "allowUnsafeAccess"));
        String fieldName = ReflectionConfigurationParser.asString(data.get((Object)"name"), "name");
        boolean allowWrite = data.containsKey((Object)"allowWrite") && ReflectionConfigurationParser.asBoolean(data.get((Object)"allowWrite"), "allowWrite");
        try {
            this.delegate.registerField(condition, clazz, fieldName, allowWrite, jniAccessible);
        }
        catch (NoSuchFieldException e) {
            this.handleMissingElement("Field " + this.formatField(clazz, fieldName) + " not found.");
        }
        catch (LinkageError e) {
            this.handleMissingElement("Could not register field " + this.formatField(clazz, fieldName) + " for reflection.", e);
        }
    }

    protected void parseMethods(C condition, boolean queriedOnly, List<Object> methods, T clazz, boolean jniAccessible) {
        for (Object method : methods) {
            this.parseMethod(condition, queriedOnly, ReflectionConfigurationParser.asMap(method, "Elements of 'methods' array must be method descriptor objects"), clazz, jniAccessible);
        }
    }

    private void parseMethod(C condition, boolean queriedOnly, EconomicMap<String, Object> data, T clazz, boolean jniAccessible) {
        block10: {
            String methodName = ReflectionConfigurationParser.asString(data.get((Object)"name"), "name");
            List<T> methodParameterTypes = null;
            Object parameterTypes = data.get((Object)"parameterTypes");
            if (parameterTypes != null && (methodParameterTypes = this.parseMethodParameters(clazz, methodName, ReflectionConfigurationParser.asList(parameterTypes, "Attribute 'parameterTypes' must be a list of type names"))) == null) {
                return;
            }
            boolean isConstructor = CONSTRUCTOR_NAME.equals(methodName);
            if (methodParameterTypes != null) {
                try {
                    if (isConstructor) {
                        this.delegate.registerConstructor(condition, queriedOnly, clazz, methodParameterTypes, jniAccessible);
                        break block10;
                    }
                    this.delegate.registerMethod(condition, queriedOnly, clazz, methodName, methodParameterTypes, jniAccessible);
                }
                catch (NoSuchMethodException e) {
                    this.handleMissingElement("Method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " not found.");
                }
                catch (LinkageError e) {
                    this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " for reflection.", e);
                }
            } else {
                try {
                    boolean found = isConstructor ? this.delegate.registerAllConstructors(condition, queriedOnly, jniAccessible, clazz) : this.delegate.registerAllMethodsWithName(condition, queriedOnly, jniAccessible, clazz, methodName);
                    if (!found) {
                        throw new JsonParserException("Method " + this.formatMethod(clazz, methodName) + " not found");
                    }
                }
                catch (LinkageError e) {
                    this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", e);
                }
            }
        }
    }

    private List<T> parseMethodParameters(T clazz, String methodName, List<Object> types) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object type : types) {
            String typeName = ReflectionConfigurationParser.asString(type, "types");
            TypeResult<T> typeResult = this.delegate.resolveType(this.conditionResolver.alwaysTrue(), NamedConfigurationTypeDescriptor.fromJSONName(typeName), true, false);
            if (!typeResult.isPresent()) {
                this.handleMissingElement("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", typeResult.getException());
                return null;
            }
            result.add(typeResult.get());
        }
        return result;
    }

    private static String formatError(Throwable e) {
        return e.getClass().getTypeName() + ": " + e.getMessage();
    }

    private String formatField(T clazz, String fieldName) {
        return this.delegate.getTypeName(clazz) + "." + fieldName;
    }

    private String formatMethod(T clazz, String methodName) {
        return this.formatMethod(clazz, methodName, Collections.emptyList());
    }

    private String formatMethod(T clazz, String methodName, List<T> paramTypes) {
        String parameterTypeNames = paramTypes.stream().map(this.delegate::getSimpleName).collect(Collectors.joining(", "));
        return this.delegate.getTypeName(clazz) + "." + methodName + "(" + parameterTypeNames + ")";
    }

    private void handleMissingElement(String message) {
        this.handleMissingElement(message, null);
    }

    protected void handleMissingElement(String msg, Throwable cause) {
        if (this.checkOption(ConfigurationParserOption.PRINT_MISSING_ELEMENTS)) {
            Object message = msg;
            if (cause != null) {
                message = (String)message + " Reason: " + ReflectionConfigurationParser.formatError(cause) + ".";
            }
            LogUtils.warning((String)message);
        }
    }
}

