/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConditionalConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.LegacyResourceConfigurationParser;
import com.oracle.svm.configure.ResourceMetadataParser;
import com.oracle.svm.configure.ResourcesRegistry;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.util.LocaleUtil;
import com.oracle.svm.util.TypeResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.collections.EconomicMap;

public abstract class ResourceConfigurationParser<C>
extends ConditionalConfigurationParser {
    protected final ResourcesRegistry<C> registry;
    protected final ConfigurationConditionResolver<C> conditionResolver;

    public static <C> ResourceConfigurationParser<C> create(boolean combinedFileSchema, ConfigurationConditionResolver<C> conditionResolver, ResourcesRegistry<C> registry, EnumSet<ConfigurationParserOption> parserOptions) {
        if (combinedFileSchema) {
            return new ResourceMetadataParser<C>(conditionResolver, registry, parserOptions);
        }
        return new LegacyResourceConfigurationParser<C>(conditionResolver, registry, parserOptions);
    }

    protected ResourceConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, ResourcesRegistry<C> registry, EnumSet<ConfigurationParserOption> parserOptions) {
        super(parserOptions);
        this.registry = registry;
        this.conditionResolver = conditionResolver;
    }

    protected void parseBundlesObject(Object bundlesObject) {
        List<Object> bundles = ResourceConfigurationParser.asList(bundlesObject, "Attribute 'bundles' must be a list of bundles");
        for (Object bundle : bundles) {
            this.parseBundle(bundle, false);
        }
    }

    protected abstract UnresolvedConfigurationCondition parseCondition(EconomicMap<String, Object> var1);

    protected void parseBundle(Object bundle, boolean inResourcesSection) {
        Object classNames;
        List<Locale> asList;
        EconomicMap<String, Object> resource = ResourceConfigurationParser.asMap(bundle, "Elements of 'bundles' list must be a bundle descriptor object");
        String bundleNameAttribute = inResourcesSection ? "bundle" : "name";
        this.checkAttributes(resource, "bundle descriptor object", Collections.singletonList(bundleNameAttribute), Arrays.asList("locales", "classNames", "condition"));
        String basename = ResourceConfigurationParser.asString(resource.get((Object)bundleNameAttribute));
        TypeResult<C> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(resource));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object locales = resource.get((Object)"locales");
        if (locales != null && !(asList = ResourceConfigurationParser.asList(locales, "Attribute 'locales' must be a list of locales").stream().map(ResourceConfigurationParser::parseLocale).collect(Collectors.toList())).isEmpty()) {
            this.registry.addResourceBundles(resolvedConfigurationCondition.get(), basename, asList);
        }
        if ((classNames = resource.get((Object)"classNames")) != null) {
            List<Object> asList2 = ResourceConfigurationParser.asList(classNames, "Attribute 'classNames' must be a list of classes");
            for (Object o : asList2) {
                String className = ResourceConfigurationParser.asString(o);
                this.registry.addClassBasedResourceBundle(resolvedConfigurationCondition.get(), basename, className);
            }
        }
        if (locales == null && classNames == null) {
            this.registry.addResourceBundles(resolvedConfigurationCondition.get(), basename);
        }
    }

    private static Locale parseLocale(Object input) {
        String localeTag = ResourceConfigurationParser.asString(input);
        Locale locale = LocaleUtil.parseLocaleFromTag((String)localeTag);
        if (locale == null) {
            throw new JsonParserException(localeTag + " is not a valid locale tag");
        }
        return locale;
    }

    protected void parseGlobsObject(Object globsObject, Object origin) {
        List<Object> globs = ResourceConfigurationParser.asList(globsObject, "Attribute 'globs' must be a list of glob patterns");
        for (Object object : globs) {
            this.parseGlobEntry(object, (condition, module, glob) -> this.registry.addGlob(condition, module, glob, origin));
        }
    }

    protected void parseGlobEntry(Object data, GlobPatternConsumer<C> resourceRegistry) {
        EconomicMap<String, Object> globObject = ResourceConfigurationParser.asMap(data, "Elements of 'globs' list must be a glob descriptor objects");
        this.checkAttributes(globObject, "glob resource descriptor object", Collections.singletonList("glob"), List.of("condition", "module"));
        TypeResult<C> resolvedConfigurationCondition = this.conditionResolver.resolveCondition(this.parseCondition(globObject));
        if (!resolvedConfigurationCondition.isPresent()) {
            return;
        }
        Object moduleObject = globObject.get((Object)"module");
        String module = ResourceConfigurationParser.asNullableString(moduleObject, "module");
        Object valueObject = globObject.get((Object)"glob");
        String value = ResourceConfigurationParser.asString(valueObject, "glob");
        resourceRegistry.accept(resolvedConfigurationCondition.get(), module, value);
    }

    protected static interface GlobPatternConsumer<T> {
        public void accept(T var1, String var2, String var3);
    }
}

