/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public class NestHostAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.NestHost;
    public final int hostClassIndex;

    public NestHostAttribute(Symbol<Name> name, int hostClassIndex) {
        assert (name == NAME);
        this.hostClassIndex = hostClassIndex;
    }

    @Override
    public boolean isSame(Attribute other, ConstantPool thisPool, ConstantPool otherPool) {
        if (!super.isSame(other, thisPool, otherPool)) {
            return false;
        }
        NestHostAttribute otherNestHostAttribute = (NestHostAttribute)other;
        return thisPool.isSame(this.hostClassIndex, otherNestHostAttribute.hostClassIndex, otherPool);
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }
}

